/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.core.util.strings.StringStuff;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;

public class AndroidSettingFactory {
    public static Intent intent(String pack, String name, String uri) {
        Intent ret;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
        Intent.IntentType type = Intent.IntentType.UNKNOWN_TARGET;
        if (name.startsWith(".")) {
            if (pack == null || pack.isEmpty()) {
                throw new IllegalArgumentException("The pack is needed to resolve the full name of " + name + ", but it's empty");
            }
            name = pack + name;
            type = Intent.IntentType.INTERNAL_TARGET;
        } else if (!name.contains(".")) {
            if (pack != null && !pack.isEmpty()) {
                name = pack + '.' + name;
            }
            type = Intent.IntentType.INTERNAL_TARGET;
        } else if (pack != null && name.startsWith(pack)) {
            type = Intent.IntentType.INTERNAL_TARGET;
        } else if (name.startsWith("android.intent.action")) {
            type = Intent.IntentType.STANDARD_ACTION;
        }
        if (name.startsWith("L") || name.contains(".")) {
            name = StringStuff.deployment2CanonicalTypeString((String)name);
        }
        Atom action = Atom.findOrCreateAsciiAtom((String)name);
        Atom mUri = null;
        if (uri != null) {
            mUri = Atom.findOrCreateAsciiAtom((String)uri);
        }
        switch (type) {
            case INTERNAL_TARGET: {
                if (uri != null) {
                    ret = new InternalIntent(action, mUri);
                    break;
                }
                ret = new InternalIntent(action);
                break;
            }
            default: {
                ret = uri != null ? new StandardIntent(action, mUri) : new StandardIntent(action);
            }
        }
        return ret;
    }

    public static Intent intent(String fullyQualifiedAction, String uri) {
        if (fullyQualifiedAction.startsWith(".")) {
            String pack = AndroidEntryPointManager.MANAGER.getPackage();
            if (pack != null) {
                return AndroidSettingFactory.intent(pack, fullyQualifiedAction, uri);
            }
            throw new IllegalArgumentException("The action " + fullyQualifiedAction + " is not fully qualified and the application package is unknown! Use  intent(String pack, String name, String uri) to build the intent!");
        }
        return AndroidSettingFactory.intent(null, fullyQualifiedAction, uri);
    }

    public static Intent intent(String fullyQualifiedAction) {
        if (fullyQualifiedAction.startsWith(".")) {
            throw new IllegalArgumentException("The action " + fullyQualifiedAction + " is not fully qualified! Use  intent(String pack, String name, null) to build the intent!");
        }
        return AndroidSettingFactory.intent(null, fullyQualifiedAction, null);
    }

    public static class IgnoreIntent
    extends Intent {
        @Override
        public Intent.IntentType getType() {
            return Intent.IntentType.IGNORE;
        }

        public IgnoreIntent(String action) {
            super(action);
        }

        public IgnoreIntent(Atom action) {
            super(action);
        }

        public IgnoreIntent(Atom action, Atom uri) {
            super(action, uri);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    public static class StandardIntent
    extends Intent {
        @Override
        public Intent.IntentType getType() {
            return Intent.IntentType.STANDARD_ACTION;
        }

        public StandardIntent(String action) {
            super(action);
        }

        public StandardIntent(Atom action) {
            super(action);
        }

        public StandardIntent(Atom action, Atom uri) {
            super(action, uri);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    public static class ExternalIntent
    extends Intent {
        @Override
        public Intent.IntentType getType() {
            return Intent.IntentType.EXTERNAL_TARGET;
        }

        public ExternalIntent(String action) {
            super(action);
        }

        public ExternalIntent(Atom action) {
            super(action);
        }

        public ExternalIntent(Atom action, Atom uri) {
            super(action, uri);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    public static class UnknownIntent
    extends Intent {
        @Override
        public Intent.IntentType getType() {
            return Intent.IntentType.UNKNOWN_TARGET;
        }

        public UnknownIntent(String action) {
            super(action);
        }

        public UnknownIntent(Atom action) {
            super(action);
        }

        public UnknownIntent(Atom action, Atom uri) {
            super(action, uri);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }

    public static class InternalIntent
    extends Intent {
        @Override
        public Intent.IntentType getType() {
            return Intent.IntentType.INTERNAL_TARGET;
        }

        public InternalIntent(String action) {
            super(action);
        }

        public InternalIntent(Atom action) {
            super(action);
        }

        public InternalIntent(Atom action, Atom uri) {
            super(action, uri);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }
    }
}

