/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.copywriter;

import com.ibm.wala.shrike.shrikeBT.Compiler;
import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.ClassWriter;
import com.ibm.wala.shrike.shrikeCT.CodeReader;
import com.ibm.wala.shrike.shrikeCT.CodeWriter;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.ConstantValueReader;
import com.ibm.wala.shrike.shrikeCT.ConstantValueWriter;
import com.ibm.wala.shrike.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrike.shrikeCT.ExceptionsWriter;
import com.ibm.wala.shrike.shrikeCT.InnerClassesReader;
import com.ibm.wala.shrike.shrikeCT.InnerClassesWriter;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrike.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrike.shrikeCT.LocalVariableTableWriter;
import com.ibm.wala.shrike.shrikeCT.SourceFileReader;
import com.ibm.wala.shrike.shrikeCT.SourceFileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;

public class CopyWriter {
    private static final String USAGE = "IBM CopyWriter Tool\nThis tool takes the following command line options:\n    <jarname> <jarname> ...   Process the classes from these jars\n    -o <jarname>              Put the resulting classes into <jarname>\n    -c <copyright>            Make the copyright string be\n                              '\u00a9 Copyright <copyright>'";
    private static OfflineInstrumenter instrumenter;
    public static String copyright;
    public static final String copyrightAttrName = "com.ibm.Copyright";
    private int replaceWith;
    private int replace;

    public static void main(String[] args) throws Exception {
        ClassInstrumenter ci;
        if (args == null || args.length == 0) {
            System.err.println(USAGE);
            System.exit(1);
        }
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("args[" + i + "] is null");
            }
            if (!args[i].equals("-c")) continue;
            copyright = "\u00a9 Copyright " + args[i + 1];
            String[] newArgs = new String[args.length - 2];
            System.arraycopy(args, 0, newArgs, 0, i);
            System.arraycopy(args, i + 2, newArgs, i, newArgs.length - i);
            args = newArgs;
            break;
        }
        if (copyright == null) {
            System.err.println(USAGE);
            System.exit(1);
        }
        ArrayList entries = new ArrayList();
        instrumenter = new OfflineInstrumenter();
        instrumenter.setManifestBuilder(entries::add);
        instrumenter.parseStandardArgs(args);
        instrumenter.setJARComment(copyright);
        instrumenter.beginTraversal();
        CopyWriter cw = new CopyWriter();
        while ((ci = instrumenter.nextClass()) != null) {
            try {
                cw.doClass(ci);
            }
            catch (UnknownAttributeException ex) {
                System.err.println(ex.getMessage() + " in " + instrumenter.getLastClassResourceName());
            }
        }
        instrumenter.writeUnmodifiedClasses();
        OutputStreamWriter w = new OutputStreamWriter(instrumenter.addOutputJarEntry(new ZipEntry("IBM-Copyright")));
        w.write(copyright + '\n');
        for (ZipEntry ze : entries) {
            w.write("  " + ze.getName() + '\n');
        }
        w.write(copyright + '\n');
        ((Writer)w).flush();
        instrumenter.endOutputJarEntry();
        instrumenter.close();
    }

    private int transformCPIndex(int i) {
        if (i == this.replace) {
            return this.replaceWith;
        }
        return i;
    }

    private ClassWriter.Element transformAttribute(ClassReader cr, int m, ClassWriter w, ClassReader.AttrIterator iter) throws InvalidClassFileException, UnknownAttributeException, Decoder.InvalidBytecodeException {
        String name = iter.getName();
        boolean needTransform = true;
        if (name.equals("Synthetic") || name.equals("Deprecated") || name.equals("LineNumberTable")) {
            needTransform = false;
        }
        int offset = iter.getRawOffset();
        int end = offset + iter.getRawSize();
        if (needTransform) {
            needTransform = false;
            int i2 = offset;
            while (i2 + 1 < end && cr.getUShort(i2) != this.replace) {
                ++i2;
            }
        }
        if (!needTransform) {
            return new ClassWriter.RawElement(cr.getBytes(), offset, end - offset);
        }
        switch (name) {
            case "Code": {
                CodeReader r = new CodeReader(iter);
                CTDecoder decoder = new CTDecoder(r);
                decoder.decode();
                MethodData md = new MethodData(decoder, cr.getMethodAccessFlags(m), CTDecoder.convertClassToType(cr.getName()), cr.getMethodName(m), cr.getMethodType(m));
                CTCompiler compiler = CTCompiler.make(w, md);
                compiler.compile();
                if (compiler.getAuxiliaryMethods().length > 0) {
                    throw new Error("Where did this auxiliary method come from?");
                }
                Compiler.Output out = compiler.getOutput();
                CodeWriter cw = new CodeWriter(w);
                cw.setMaxLocals(out.getMaxLocals());
                cw.setMaxStack(out.getMaxStack());
                cw.setCode(out.getCode());
                cw.setRawHandlers(out.getRawHandlers());
                ClassReader.AttrIterator iterator = new ClassReader.AttrIterator();
                r.initAttributeIterator(iterator);
                cw.setAttributes(this.collectAttributes(cr, m, w, iterator));
                return cw;
            }
            case "ConstantValue": {
                ConstantValueReader r = new ConstantValueReader(iter);
                ConstantValueWriter cw = new ConstantValueWriter(w);
                cw.setValueCPIndex(this.transformCPIndex(r.getValueCPIndex()));
                return cw;
            }
            case "SourceFile": {
                SourceFileReader r = new SourceFileReader(iter);
                SourceFileWriter cw = new SourceFileWriter(w);
                cw.setSourceFileCPIndex(this.transformCPIndex(r.getSourceFileCPIndex()));
                return cw;
            }
            case "LocalVariableTableReader": {
                LocalVariableTableReader lr = new LocalVariableTableReader(iter);
                LocalVariableTableWriter lw = new LocalVariableTableWriter(w);
                int[] table = lr.getRawTable();
                for (int i3 = 0; i3 < table.length; i3 += 5) {
                    table[i3 + 2] = this.transformCPIndex(table[i3 + 2]);
                    table[i3 + 3] = this.transformCPIndex(table[i3 + 3]);
                }
                lw.setRawTable(table);
                return lw;
            }
            case "Exceptions": {
                ExceptionsReader lr = new ExceptionsReader(iter);
                ExceptionsWriter lw = new ExceptionsWriter(w);
                int[] table = lr.getRawTable();
                Arrays.setAll(table, i -> this.transformCPIndex(table[i]));
                lw.setRawTable(table);
                return lw;
            }
            case "InnerClasses": {
                InnerClassesReader lr = new InnerClassesReader(iter);
                InnerClassesWriter lw = new InnerClassesWriter(w);
                int[] table = lr.getRawTable();
                for (int i4 = 0; i4 < table.length; i4 += 4) {
                    table[i4] = this.transformCPIndex(table[i4]);
                    table[i4 + 1] = this.transformCPIndex(table[i4 + 1]);
                    table[i4 + 2] = this.transformCPIndex(table[i4 + 2]);
                }
                lw.setRawTable(table);
                return lw;
            }
        }
        throw new UnknownAttributeException(name);
    }

    private ClassWriter.Element[] collectAttributes(ClassReader cr, int m, ClassWriter w, ClassReader.AttrIterator iter) throws InvalidClassFileException, UnknownAttributeException, Decoder.InvalidBytecodeException {
        ClassWriter.Element[] elems = new ClassWriter.Element[iter.getRemainingAttributesCount()];
        for (int i = 0; i < elems.length; ++i) {
            elems[i] = this.transformAttribute(cr, m, w, iter);
            iter.advance();
        }
        return elems;
    }

    private static int copyEntry(ConstantPoolParser cp, ClassWriter w, int i) throws InvalidClassFileException {
        byte t = cp.getItemType(i);
        switch (t) {
            case 8: {
                return w.addCPString(cp.getCPString(i));
            }
            case 7: {
                return w.addCPClass(cp.getCPClass(i));
            }
            case 9: {
                return w.addCPFieldRef(cp.getCPRefClass(i), cp.getCPRefName(i), cp.getCPRefType(i));
            }
            case 11: {
                return w.addCPInterfaceMethodRef(cp.getCPRefClass(i), cp.getCPRefName(i), cp.getCPRefType(i));
            }
            case 10: {
                return w.addCPMethodRef(cp.getCPRefClass(i), cp.getCPRefName(i), cp.getCPRefType(i));
            }
            case 12: {
                return w.addCPNAT(cp.getCPNATName(i), cp.getCPNATType(i));
            }
            case 3: {
                return w.addCPInt(cp.getCPInt(i));
            }
            case 4: {
                return w.addCPFloat(cp.getCPFloat(i));
            }
            case 5: {
                return w.addCPLong(cp.getCPLong(i));
            }
            case 6: {
                return w.addCPDouble(cp.getCPDouble(i));
            }
            case 1: {
                return w.addCPUtf8(cp.getCPUtf8(i));
            }
        }
        return -1;
    }

    private void doClass(ClassInstrumenter ci) throws Exception {
        ClassReader cr = ci.getReader();
        ClassWriter w = new ClassWriter();
        w.setForceAddCPEntries(true);
        int r = w.addCPUtf8(copyright);
        if (r != 1) {
            throw new Error("Invalid constant pool index: " + r);
        }
        ConstantPoolParser cp = cr.getCP();
        int CPCount = cp.getItemCount();
        if (1 < CPCount) {
            byte itemType = cp.getItemType(1);
            switch (itemType) {
                case 5: 
                case 6: {
                    r = w.addCPUtf8("");
                    if (r == 2) break;
                    throw new Error("Invalid constant pool index for dummy: " + r);
                }
                default: {
                    throw new UnsupportedOperationException(String.format("unexpected constant-pool item type %s", itemType));
                }
            }
        }
        for (int i = 2; i < CPCount; ++i) {
            r = CopyWriter.copyEntry(cp, w, i);
            if (r == -1 || r == i) continue;
            throw new Error("Invalid constant pool index allocated: " + r + ", expected " + i);
        }
        w.setForceAddCPEntries(false);
        this.replaceWith = CopyWriter.copyEntry(cp, w, 1);
        this.replace = 1;
        w.setMajorVersion(cr.getMajorVersion());
        w.setMinorVersion(cr.getMinorVersion());
        w.setAccessFlags(cr.getAccessFlags());
        w.setName(cr.getName());
        w.setSuperName(cr.getSuperName());
        w.setInterfaceNames(cr.getInterfaceNames());
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        int fieldCount = cr.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            cr.initFieldAttributeIterator(i, iter);
            w.addField(cr.getFieldAccessFlags(i), cr.getFieldName(i), cr.getFieldType(i), this.collectAttributes(cr, i, w, iter));
        }
        int methodCount = cr.getMethodCount();
        for (int i = 0; i < methodCount; ++i) {
            cr.initMethodAttributeIterator(i, iter);
            w.addMethod(cr.getMethodAccessFlags(i), cr.getMethodName(i), cr.getMethodType(i), this.collectAttributes(cr, i, w, iter));
        }
        cr.initClassAttributeIterator(iter);
        while (iter.isValid()) {
            w.addClassAttribute(this.transformAttribute(cr, 0, w, iter));
            iter.advance();
        }
        instrumenter.outputModifiedClass(ci, w);
    }

    static class UnknownAttributeException
    extends Exception {
        private static final long serialVersionUID = 8845177787110364793L;

        UnknownAttributeException(String t) {
            super("Attribute '" + t + "' not understood");
        }
    }
}

