/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.Constants;
import com.ibm.wala.shrike.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class ArrayStoreInstruction
extends Instruction
implements IArrayStoreInstruction {
    private static final ArrayStoreInstruction[] preallocated = ArrayStoreInstruction.preallocate();

    private ArrayStoreInstruction(short opcode) {
        super(opcode);
    }

    private static ArrayStoreInstruction[] preallocate() {
        ArrayStoreInstruction[] r = new ArrayStoreInstruction[9];
        for (short i = 79; i <= 86; i = (short)(i + 1)) {
            r[i - 79] = new ArrayStoreInstruction(i);
        }
        r[8] = r[5];
        return r;
    }

    public static ArrayStoreInstruction make(String type) throws IllegalArgumentException {
        int i = Util.getTypeIndex(type);
        if (i < 0 || i > 8) {
            throw new IllegalArgumentException("Invalid type " + type + " for ArrayStoreInstruction");
        }
        return preallocated[i];
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayStoreInstruction) {
            ArrayStoreInstruction i = (ArrayStoreInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + 148791;
    }

    @Override
    public int getPoppedCount() {
        return 3;
    }

    @Override
    public String getType() {
        return Constants.indexedTypes[this.opcode - 79];
    }

    @Override
    public String toString() {
        return "ArrayStore(" + this.getType() + ')';
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitArrayStore(this);
    }

    @Override
    public boolean isPEI() {
        return true;
    }
}

