/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.AttributeReader;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import java.util.Arrays;

public final class InnerClassesReader
extends AttributeReader {
    public InnerClassesReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "InnerClasses");
        this.checkSize(this.attr, 8);
        int count = this.cr.getUShort(this.attr + 6);
        this.checkSizeEquals(this.attr + 8, 8 * count);
    }

    public int[] getRawTable() {
        int count = this.cr.getUShort(this.attr + 6);
        int[] r = new int[count * 4];
        Arrays.setAll(r, i -> this.cr.getUShort(this.attr + 8 + i * 2));
        return r;
    }

    public String[] getInnerClasses() throws InvalidClassFileException {
        int count = this.cr.getUShort(this.attr + 6);
        String[] r = new String[count];
        ConstantPoolParser cp = this.cr.getCP();
        for (int i = 0; i < r.length; ++i) {
            r[i] = cp.getCPClass(this.cr.getUShort(this.attr + 8 + i * 8));
        }
        return r;
    }

    public String getOuterClass(String s) throws InvalidClassFileException {
        String[] inner = this.getInnerClasses();
        for (int i = 0; i < inner.length; ++i) {
            int x;
            if (!inner[i].equals(s) || (x = this.cr.getUShort(this.attr + 8 + i * 8 + 2)) == 0) continue;
            ConstantPoolParser cp = this.cr.getCP();
            return cp.getCPClass(this.cr.getUShort(this.attr + 8 + i * 8 + 2));
        }
        return null;
    }

    public int getAccessFlags(String s) throws InvalidClassFileException {
        String[] inner = this.getInnerClasses();
        for (int i = 0; i < inner.length; ++i) {
            if (!inner[i].equals(s)) continue;
            return this.cr.getUShort(this.attr + 8 + i * 8 + 6);
        }
        return 0;
    }
}

