/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeBT.Compiler;
import com.ibm.wala.shrike.shrikeBT.GotoInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrike.shrikeBT.analysis.ClassHierarchyProvider;
import com.ibm.wala.shrike.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrike.shrikeCT.ClassWriter;
import com.ibm.wala.shrike.shrikeCT.StackMapConstants;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class StackMapTableWriter
extends ClassWriter.Element {
    private final byte[] data;

    public StackMapTableWriter(ClassWriter writer, List<StackMapConstants.StackMapFrame> frames) throws IOException {
        this.data = StackMapTableWriter.serialize(writer, frames);
    }

    private static byte[] serialize(ClassWriter writer, List<StackMapConstants.StackMapFrame> frames) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        for (StackMapConstants.StackMapFrame frame : frames) {
            frame.write(data, writer);
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        StackMapTableWriter.writeUShort(bs, writer.addCPUtf8("StackMapTable"));
        StackMapTableWriter.writeInt(bs, data.size() + 2);
        StackMapTableWriter.writeUShort(bs, frames.size());
        data.writeTo(bs);
        return bs.toByteArray();
    }

    public StackMapTableWriter(ClassWriter writer, MethodData method, Compiler.Output output, ClassHierarchyProvider cha, String[][] vars) throws Analyzer.FailureException, IOException {
        this(writer, StackMapTableWriter.stackMapTable(method, output, cha, vars, null));
    }

    public StackMapTableWriter(ClassWriter writer, MethodData method, Compiler.Output output, ClassHierarchyProvider cha, String[][] vars, List<StackMapConstants.StackMapFrame> reuseFrames) throws Analyzer.FailureException, IOException {
        this(writer, StackMapTableWriter.stackMapTable(method, output, cha, vars, reuseFrames));
    }

    private static List<StackMapConstants.StackMapFrame> remapStackFrames(List<StackMapConstants.StackMapFrame> sm, int[] newBytecodesToOldBytecodes) {
        int i;
        HashMap oldToNew = HashMapFactory.make();
        for (i = newBytecodesToOldBytecodes.length - 1; i >= 0; --i) {
            oldToNew.put(newBytecodesToOldBytecodes[i], i);
        }
        i = 1;
        int[] positions = new int[sm.size()];
        Iterator<StackMapConstants.StackMapFrame> sms = sm.iterator();
        int position = sms.next().getOffset();
        positions[0] = (Integer)oldToNew.get(position);
        while (sms.hasNext()) {
            positions[i++] = (Integer)oldToNew.get(position += sms.next().getOffset() + 1);
        }
        for (i = positions.length - 1; i > 0; --i) {
            positions[i] = positions[i] - positions[i - 1] - 1;
        }
        ArrayList<StackMapConstants.StackMapFrame> newFrames = new ArrayList<StackMapConstants.StackMapFrame>(sm.size());
        for (i = 0; i < sm.size(); ++i) {
            newFrames.add(new StackMapConstants.StackMapFrame(sm.get(i), positions[i]));
        }
        return newFrames;
    }

    public StackMapTableWriter(ClassWriter w, List<StackMapConstants.StackMapFrame> sm, int[] newBytecodesToOldBytecodes) throws IOException {
        this(w, StackMapTableWriter.remapStackFrames(sm, newBytecodesToOldBytecodes));
    }

    static StackMapConstants.StackMapType item(String type) {
        if (type == null) {
            return StackMapConstants.Item.ITEM_Top;
        }
        if (type.equals("L;")) {
            return StackMapConstants.Item.ITEM_Null;
        }
        if (type.equals("TOP")) {
            return StackMapConstants.Item.ITEM_Top;
        }
        if (type.equals("THIS")) {
            return StackMapConstants.Item.ITEM_UninitializedThis;
        }
        if (type.equals("I")) {
            return StackMapConstants.Item.ITEM_Integer;
        }
        if (type.equals("F")) {
            return StackMapConstants.Item.ITEM_Float;
        }
        if (type.equals("D")) {
            return StackMapConstants.Item.ITEM_Double;
        }
        if (type.equals("J")) {
            return StackMapConstants.Item.ITEM_Long;
        }
        if (type.startsWith("#")) {
            return new StackMapConstants.UninitializedType(type);
        }
        return new StackMapConstants.ObjectType(type);
    }

    static void writeUByte(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[1];
        ClassWriter.setUByte(bytes, 0, v);
        s.write(bytes);
    }

    static void writeUShort(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[2];
        ClassWriter.setUShort(bytes, 0, v);
        s.write(bytes);
    }

    static void writeInt(OutputStream s, int v) throws IOException {
        byte[] bytes = new byte[4];
        ClassWriter.setInt(bytes, 0, v);
        s.write(bytes);
    }

    static StackMapConstants.StackMapType[] trim(StackMapConstants.StackMapType[] types) {
        int i;
        for (i = types.length - 1; i >= 0 && (types[i] == null || types[i] == StackMapConstants.Item.ITEM_Null || types[i] == StackMapConstants.Item.ITEM_Top); --i) {
        }
        if (i < 0) {
            return new StackMapConstants.StackMapType[0];
        }
        if (i < types.length - 1) {
            StackMapConstants.StackMapType[] trimmed = new StackMapConstants.StackMapType[i + 1];
            System.arraycopy(types, 0, trimmed, 0, i + 1);
            return trimmed;
        }
        return types;
    }

    private static String hackUnknown(String type) {
        if (type == null) {
            return type;
        }
        if (type.startsWith("[")) {
            return '[' + StackMapTableWriter.hackUnknown(type.substring(1));
        }
        if ("L?;".equals(type)) {
            return "Ljava/lang/Object;";
        }
        return type;
    }

    static StackMapConstants.StackMapType[] types(String[] types, boolean locals) {
        StackMapConstants.StackMapType[] stackTypes = new StackMapConstants.StackMapType[types.length];
        int x = 0;
        for (int j = 0; j < types.length; ++j) {
            StackMapConstants.StackMapType stackType = StackMapTableWriter.item(StackMapTableWriter.hackUnknown(types[j]));
            stackTypes[x++] = stackType;
            if (!locals || stackType.size() != 2) continue;
            ++j;
        }
        return StackMapTableWriter.trim(stackTypes);
    }

    private static boolean isUselessGoto(IInstruction inst, int index) {
        return inst instanceof GotoInstruction && ((GotoInstruction)inst).getBranchTargets()[0] == index + 1;
    }

    public static List<StackMapConstants.StackMapFrame> stackMapTable(MethodData method, Compiler.Output output, ClassHierarchyProvider cha, String[][] vars, List<StackMapConstants.StackMapFrame> reuseFrames) throws Analyzer.FailureException {
        int idx = 0;
        ArrayList<StackMapConstants.StackMapFrame> frames = new ArrayList<StackMapConstants.StackMapFrame>();
        int[] instructionToBytecode = output.getInstructionOffsets();
        IInstruction[] insts = method.getInstructions();
        Verifier typeChecker = new Verifier(method, instructionToBytecode, vars);
        if (cha != null) {
            typeChecker.setClassHierarchy(cha);
        }
        typeChecker.computeTypes();
        BitSet bbs = typeChecker.getBasicBlockStarts();
        int offset = 0;
        for (int i = 1; i < insts.length; ++i) {
            if (!bbs.get(i) || StackMapTableWriter.isUselessGoto(insts[i], i)) continue;
            int position = instructionToBytecode[i];
            assert (position - offset > 0 || offset == 0);
            int frameOffset = offset == 0 ? position : position - offset - 1;
            offset = position;
            if (reuseFrames != null) {
                if (idx < reuseFrames.size() && reuseFrames.get(idx).getOffset() == frameOffset) {
                    frames.add(reuseFrames.get(idx++));
                    continue;
                }
                reuseFrames = null;
            }
            int frameType = -1;
            String[] localTypes = typeChecker.getLocalTypes()[i];
            StackMapConstants.StackMapType[] localWriteTypes = localTypes != null ? StackMapTableWriter.types(localTypes, true) : new StackMapConstants.StackMapType[]{};
            String[] stackTypes = typeChecker.getStackTypes()[i];
            StackMapConstants.StackMapType[] stackWriteTypes = stackTypes != null ? StackMapTableWriter.types(stackTypes, false) : new StackMapConstants.StackMapType[]{};
            frames.add(new StackMapConstants.StackMapFrame(frameType, frameOffset, localWriteTypes, stackWriteTypes));
        }
        return frames;
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public int copyInto(byte[] buf, int offset) {
        System.arraycopy(this.data, 0, buf, offset + 0, this.data.length);
        return this.data.length + offset;
    }
}

