/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.sourcepos;

import com.ibm.wala.shrike.sourcepos.InvalidCRTDataException;
import java.util.ArrayList;

public final class CRTFlags {
    static final short CRT_SOURCE_INFO = 512;
    private static final String[] flagNames = new String[]{"CRT_STATEMENT", "CRT_BLOCK", "CRT_ASSIGNMENT", "CRT_FLOW_CONTROLLER", "CRT_FLOW_TARGET", "CRT_INVOKE", "CRT_CREATE", "CRT_BRANCH_TRUE", "CRT_BRANCH_FALSE", "CRT_SOURCE_INFO"};
    private static final String WARN_INVALID_FLAG = "Error at CRT entry %1$s: invalid flag %2$s";
    private final short flags;

    CRTFlags(short flags) throws InvalidCRTDataException {
        this.flags = flags;
        if (!this.isFlagValid()) {
            throw new InvalidCRTDataException(WARN_INVALID_FLAG, Integer.toHexString(flags));
        }
    }

    public String[] getFlagNames() {
        ArrayList<String> names = new ArrayList<String>();
        int index = 0;
        short tFlags = this.flags;
        while (tFlags > 0) {
            if (tFlags % 2 == 1) {
                if (index < flagNames.length) {
                    names.add(flagNames[index]);
                } else {
                    names.add("UNKNOWN (" + Integer.toHexString(2 << index) + ')');
                }
            }
            tFlags = (short)(tFlags >> 1);
            ++index;
        }
        return names.toArray(new String[0]);
    }

    private boolean isFlagValid() {
        return 0 < this.flags && this.flags < 2 << flagNames.length - 1;
    }
}

