/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import java.util.Iterator;
import java.util.stream.Stream;

public abstract class AbstractGraph<T>
implements Graph<T> {
    protected abstract NodeManager<T> getNodeManager();

    protected abstract EdgeManager<T> getEdgeManager();

    @Override
    public Stream<T> stream() {
        return this.getNodeManager().stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getNodeManager().iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.getNodeManager().getNumberOfNodes();
    }

    @Override
    public int getPredNodeCount(T n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getPredNodeCount(n);
    }

    @Override
    public Iterator<T> getPredNodes(T n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getPredNodes(n);
    }

    @Override
    public int getSuccNodeCount(T n) throws IllegalArgumentException {
        if (!this.containsNode(n) || n == null) {
            throw new IllegalArgumentException("node not in graph " + n);
        }
        return this.getEdgeManager().getSuccNodeCount(n);
    }

    @Override
    public Iterator<T> getSuccNodes(T n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getSuccNodes(n);
    }

    @Override
    public void addNode(T n) {
        this.getNodeManager().addNode(n);
    }

    @Override
    public void addEdge(T src, T dst) throws IllegalArgumentException {
        this.getEdgeManager().addEdge(src, dst);
    }

    @Override
    public void removeEdge(T src, T dst) throws IllegalArgumentException {
        this.getEdgeManager().removeEdge(src, dst);
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        if (src == null) {
            throw new IllegalArgumentException("src is null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst is null");
        }
        return this.getEdgeManager().hasEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(T node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeAllIncidentEdges(node);
    }

    @Override
    public void removeIncomingEdges(T node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeIncomingEdges(node);
    }

    @Override
    public void removeOutgoingEdges(T node) throws IllegalArgumentException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeOutgoingEdges(node);
    }

    @Override
    public void removeNodeAndEdges(T N) throws IllegalArgumentException {
        if (N == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        this.getEdgeManager().removeAllIncidentEdges(N);
        this.getNodeManager().removeNode(N);
    }

    @Override
    public void removeNode(T n) throws IllegalArgumentException {
        if (n == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        this.getNodeManager().removeNode(n);
    }

    protected String nodeString(T n, boolean forEdge) {
        return n.toString();
    }

    protected String edgeString(T from, T to) {
        return " --> ";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T n : this) {
            sb.append(this.nodeString(n, false)).append('\n');
            for (T s : Iterator2Iterable.make(this.getSuccNodes(n))) {
                sb.append(this.edgeString(n, s)).append(this.nodeString(s, true));
                sb.append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean containsNode(T n) {
        if (n == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getNodeManager().containsNode(n);
    }
}

