/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public class DelegatingNumberedNodeManager<T extends INodeWithNumber>
implements NumberedNodeManager<T> {
    private final double BUFFER_FACTOR = 1.5;
    private INodeWithNumber[] nodes = new INodeWithNumber[20];
    private int maxNumber = -1;
    private int numberOfNodes = 0;

    @Override
    public int getNumber(T N) {
        if (N == null) {
            throw new IllegalArgumentException("N is null");
        }
        T n = N;
        return n.getGraphNodeId();
    }

    @Override
    public T getNode(int number) {
        try {
            return (T)this.nodes[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid number " + number, e);
        }
    }

    @Override
    public int getMaxNumber() {
        return this.maxNumber;
    }

    @Override
    public Iterator<T> iterator() {
        final INodeWithNumber[] arr = this.nodes;
        return new Iterator<T>(){
            int nextCounter = -1;
            {
                this.advance();
            }

            void advance() {
                for (int i = this.nextCounter + 1; i < arr.length; ++i) {
                    if (arr[i] == null) continue;
                    this.nextCounter = i;
                    return;
                }
                this.nextCounter = -1;
            }

            @Override
            public boolean hasNext() {
                return this.nextCounter != -1;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    int r = this.nextCounter;
                    this.advance();
                    return arr[r];
                }
                return null;
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    @Override
    public Stream<T> stream() {
        return Arrays.stream(this.nodes).filter(Objects::nonNull).map(node -> node);
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public void addNode(T n) {
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        T N = n;
        int number = N.getGraphNodeId();
        if (number == -1) {
            ++this.maxNumber;
            N.setGraphNodeId(this.maxNumber);
            number = this.maxNumber;
        } else if (number > this.maxNumber) {
            this.maxNumber = number;
        }
        this.ensureCapacity(number);
        if (this.nodes[number] != null && this.nodes[number] != N) {
            Assertions.UNREACHABLE("number: " + number + " N: " + N + " nodes[number]: " + this.nodes[number]);
        }
        this.nodes[number] = N;
        ++this.numberOfNodes;
    }

    private void ensureCapacity(int number) {
        if (this.nodes.length < number + 1) {
            int newLength = (int)((double)(number + 1) * 1.5);
            this.nodes = Arrays.copyOf(this.nodes, newLength);
        }
    }

    @Override
    public void removeNode(T n) {
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        T N = n;
        int number = N.getGraphNodeId();
        if (number == -1) {
            throw new IllegalArgumentException("Cannot remove node, not in graph");
        }
        if (this.nodes[number] != null) {
            this.nodes[number] = null;
            --this.numberOfNodes;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Nodes:\n");
        for (int i = 0; i <= this.maxNumber; ++i) {
            result.append(i).append(' ');
            if (this.nodes[i] != null) {
                result.append(this.nodes[i].toString());
            }
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public boolean containsNode(T n) {
        if (n == null) {
            throw new IllegalArgumentException("n is null");
        }
        T N = n;
        int number = N.getGraphNodeId();
        if (number == -1) {
            return false;
        }
        if (number >= this.nodes.length) {
            throw new IllegalArgumentException("node already has a graph node id, but is not registered there in this graph (number too big)\nthis graph implementation is fragile and won't support this kind of test\n" + n.getClass() + " : " + n);
        }
        if (this.nodes[number] != N) {
            throw new IllegalArgumentException("node already has a graph node id, but is not registered there in this graph\nthis graph implementation is fragile and won't support this kind of test\n" + n.getClass() + " : " + n);
        }
        return true;
    }

    @Override
    public Iterator<T> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, this);
    }
}

