/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.labeled;

import com.ibm.wala.util.collections.ArraySet;
import com.ibm.wala.util.collections.ArraySetMultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.graph.labeled.NumberedLabeledEdgeManager;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SparseNumberedLabeledEdgeManager<T, U>
implements Serializable,
NumberedLabeledEdgeManager<T, U> {
    private static final long serialVersionUID = 5298089288917726790L;
    private final U defaultLabel;
    private final NumberedNodeManager<T> nodeManager;
    private final Map<U, SparseNumberedEdgeManager<T>> edgeLabelToManager = HashMapFactory.make();
    private final ArraySetMultiMap<T, U> nodeToPredLabels = new ArraySetMultiMap();
    private final ArraySetMultiMap<T, U> nodeToSuccLabels = new ArraySetMultiMap();

    private SparseNumberedEdgeManager<T> getManagerForLabel(U label) {
        SparseNumberedEdgeManager<T> ret = this.edgeLabelToManager.get(label);
        if (ret == null) {
            ret = new SparseNumberedEdgeManager<T>(this.nodeManager);
            this.edgeLabelToManager.put(label, ret);
        }
        return ret;
    }

    @Override
    public void addEdge(T src, T dst, U label) {
        this.nodeToSuccLabels.put((Object)src, (Object)label);
        this.nodeToPredLabels.put((Object)dst, (Object)label);
        this.getManagerForLabel(label).addEdge(src, dst);
    }

    @Override
    public int getPredNodeCount(T N, U label) {
        return this.getManagerForLabel(label).getPredNodeCount(N);
    }

    @Override
    public Iterator<T> getPredNodes(T N, U label) {
        return this.getManagerForLabel(label).getPredNodes(N);
    }

    @Override
    public int getSuccNodeCount(T N, U label) {
        return this.getManagerForLabel(label).getSuccNodeCount(N);
    }

    @Override
    public Iterator<? extends T> getSuccNodes(T N, U label) {
        return this.getManagerForLabel(label).getSuccNodes(N);
    }

    @Override
    public boolean hasEdge(T src, T dst, U label) {
        return this.getManagerForLabel(label).hasEdge(src, dst);
    }

    @Override
    public void removeAllIncidentEdges(T node) {
        this.removeIncomingEdges(node);
        this.removeOutgoingEdges(node);
    }

    @Override
    public void removeEdge(T src, T dst, U label) throws IllegalArgumentException {
        this.getManagerForLabel(label).removeEdge(src, dst);
    }

    @Override
    public void removeIncomingEdges(T node) throws IllegalArgumentException {
        for (Object label : this.nodeToPredLabels.get((Object)node)) {
            this.getManagerForLabel(label).removeIncomingEdges(node);
        }
    }

    @Override
    public void removeOutgoingEdges(T node) throws IllegalArgumentException {
        for (Object label : this.nodeToSuccLabels.get((Object)node)) {
            this.getManagerForLabel(label).removeOutgoingEdges(node);
        }
    }

    public SparseNumberedLabeledEdgeManager(NumberedNodeManager<T> nodeManager, U defaultLabel) {
        this.defaultLabel = defaultLabel;
        this.nodeManager = nodeManager;
        if (nodeManager == null) {
            throw new IllegalArgumentException("null nodeManager");
        }
    }

    public SparseNumberedLabeledEdgeManager(NumberedNodeManager<T> nodeManager) {
        this.defaultLabel = null;
        this.nodeManager = nodeManager;
        if (nodeManager == null) {
            throw new IllegalArgumentException("null nodeManager");
        }
    }

    @Override
    public Iterator<? extends U> getPredLabels(T N) {
        return ((ArraySet)this.nodeToPredLabels.get((Object)N)).iterator();
    }

    @Override
    public Iterator<? extends U> getSuccLabels(T N) {
        return ((ArraySet)this.nodeToSuccLabels.get((Object)N)).iterator();
    }

    @Override
    public Set<? extends U> getEdgeLabels(T src, T dst) {
        HashSet labels = HashSetFactory.make();
        for (Map.Entry<U, SparseNumberedEdgeManager<T>> entry : this.edgeLabelToManager.entrySet()) {
            if (!entry.getValue().hasEdge(src, dst)) continue;
            labels.add(entry.getKey());
        }
        return labels;
    }

    @Override
    public void addEdge(T src, T dst) {
        assert (this.defaultLabel != null);
        this.addEdge(src, dst, this.defaultLabel);
    }

    @Override
    public int getPredNodeCount(T N) {
        int count = 0;
        for (Object label : this.nodeToPredLabels.get((Object)N)) {
            count += this.getPredNodeCount(N, label);
        }
        return count;
    }

    @Override
    public Iterator<T> getPredNodes(T N) {
        HashSet preds = HashSetFactory.make();
        for (Object label : this.nodeToPredLabels.get((Object)N)) {
            preds.addAll(Iterator2Collection.toSet(this.getPredNodes(N, label)));
        }
        return preds.iterator();
    }

    @Override
    public int getSuccNodeCount(T N) {
        int count = 0;
        for (Object label : this.nodeToSuccLabels.get((Object)N)) {
            count += this.getSuccNodeCount(N, label);
        }
        return count;
    }

    @Override
    public Iterator<T> getSuccNodes(T N) {
        HashSet succs = HashSetFactory.make();
        for (Object label : this.nodeToSuccLabels.get((Object)N)) {
            succs.addAll(Iterator2Collection.toSet(this.getSuccNodes(N, label)));
        }
        return succs.iterator();
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        for (Object label : this.nodeToSuccLabels.get((Object)src)) {
            if (!this.hasEdge(src, dst, label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeEdge(T src, T dst) throws UnsupportedOperationException {
        for (Object label : this.nodeToSuccLabels.get((Object)src)) {
            if (!this.hasEdge(src, dst, label)) continue;
            this.removeEdge(src, dst, label);
        }
    }

    @Override
    public U getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public IntSet getPredNodeNumbers(T node, U label) throws IllegalArgumentException {
        return this.getManagerForLabel(label).getPredNodeNumbers(node);
    }

    @Override
    public IntSet getSuccNodeNumbers(T node, U label) throws IllegalArgumentException {
        return this.getManagerForLabel(label).getSuccNodeNumbers(node);
    }

    @Override
    public IntSet getPredNodeNumbers(T node) {
        BitVectorIntSet preds = new BitVectorIntSet();
        for (Object label : this.nodeToPredLabels.get((Object)node)) {
            preds.addAll(this.getPredNodeNumbers(node, label));
        }
        return preds;
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) {
        BitVectorIntSet succs = new BitVectorIntSet();
        for (Object label : this.nodeToSuccLabels.get((Object)node)) {
            succs.addAll(this.getSuccNodeNumbers(node, label));
        }
        return succs;
    }
}

