/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PushBatchesOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String batchId;
    protected InputStream file;
    protected String filename;

    protected PushBatchesOptions() {
    }

    protected PushBatchesOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.batchId, (String)"batchId cannot be empty");
        Validator.isTrue((builder.file == null || builder.filename != null ? 1 : 0) != 0, (String)"filename cannot be null if file is not null.");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.batchId = builder.batchId;
        this.file = builder.file;
        this.filename = builder.filename;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String batchId() {
        return this.batchId;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String batchId;
        private InputStream file;
        private String filename;

        private Builder(PushBatchesOptions pushBatchesOptions) {
            this.projectId = pushBatchesOptions.projectId;
            this.collectionId = pushBatchesOptions.collectionId;
            this.batchId = pushBatchesOptions.batchId;
            this.file = pushBatchesOptions.file;
            this.filename = pushBatchesOptions.filename;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId, String batchId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
            this.batchId = batchId;
        }

        public PushBatchesOptions build() {
            return new PushBatchesOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

