/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.UpdateDocumentClassifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class UpdateDocumentClassifierOptions
extends GenericModel {
    protected String projectId;
    protected String classifierId;
    protected UpdateDocumentClassifier classifier;
    protected InputStream trainingData;
    protected InputStream testData;

    protected UpdateDocumentClassifierOptions() {
    }

    protected UpdateDocumentClassifierOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notNull((Object)((Object)builder.classifier), (String)"classifier cannot be null");
        this.projectId = builder.projectId;
        this.classifierId = builder.classifierId;
        this.classifier = builder.classifier;
        this.trainingData = builder.trainingData;
        this.testData = builder.testData;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String classifierId() {
        return this.classifierId;
    }

    public UpdateDocumentClassifier classifier() {
        return this.classifier;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public InputStream testData() {
        return this.testData;
    }

    public static class Builder {
        private String projectId;
        private String classifierId;
        private UpdateDocumentClassifier classifier;
        private InputStream trainingData;
        private InputStream testData;

        private Builder(UpdateDocumentClassifierOptions updateDocumentClassifierOptions) {
            this.projectId = updateDocumentClassifierOptions.projectId;
            this.classifierId = updateDocumentClassifierOptions.classifierId;
            this.classifier = updateDocumentClassifierOptions.classifier;
            this.trainingData = updateDocumentClassifierOptions.trainingData;
            this.testData = updateDocumentClassifierOptions.testData;
        }

        public Builder() {
        }

        public Builder(String projectId, String classifierId, UpdateDocumentClassifier classifier) {
            this.projectId = projectId;
            this.classifierId = classifierId;
            this.classifier = classifier;
        }

        public UpdateDocumentClassifierOptions build() {
            return new UpdateDocumentClassifierOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder classifier(UpdateDocumentClassifier classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder testData(InputStream testData) {
            this.testData = testData;
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            return this;
        }

        public Builder testData(File testData) throws FileNotFoundException {
            this.testData = new FileInputStream(testData);
            return this;
        }
    }
}

