/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class CreateSentimentModelOptions
extends GenericModel {
    protected String language;
    protected InputStream trainingData;
    protected String name;
    protected Map<String, Object> userMetadata;
    protected String description;
    protected String modelVersion;
    protected String workspaceId;
    protected String versionDescription;

    protected CreateSentimentModelOptions() {
    }

    protected CreateSentimentModelOptions(Builder builder) {
        Validator.notNull((Object)builder.language, (String)"language cannot be null");
        Validator.notNull((Object)builder.trainingData, (String)"trainingData cannot be null");
        this.language = builder.language;
        this.trainingData = builder.trainingData;
        this.name = builder.name;
        this.userMetadata = builder.userMetadata;
        this.description = builder.description;
        this.modelVersion = builder.modelVersion;
        this.workspaceId = builder.workspaceId;
        this.versionDescription = builder.versionDescription;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String language() {
        return this.language;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public String description() {
        return this.description;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String versionDescription() {
        return this.versionDescription;
    }

    public static class Builder {
        private String language;
        private InputStream trainingData;
        private String name;
        private Map<String, Object> userMetadata;
        private String description;
        private String modelVersion;
        private String workspaceId;
        private String versionDescription;

        private Builder(CreateSentimentModelOptions createSentimentModelOptions) {
            this.language = createSentimentModelOptions.language;
            this.trainingData = createSentimentModelOptions.trainingData;
            this.name = createSentimentModelOptions.name;
            this.userMetadata = createSentimentModelOptions.userMetadata;
            this.description = createSentimentModelOptions.description;
            this.modelVersion = createSentimentModelOptions.modelVersion;
            this.workspaceId = createSentimentModelOptions.workspaceId;
            this.versionDescription = createSentimentModelOptions.versionDescription;
        }

        public Builder() {
        }

        public Builder(String language, InputStream trainingData) {
            this.language = language;
            this.trainingData = trainingData;
        }

        public CreateSentimentModelOptions build() {
            return new CreateSentimentModelOptions(this);
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder userMetadata(Map<String, Object> userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            return this;
        }
    }
}

