/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AddAudioOptions
extends GenericModel {
    protected String customizationId;
    protected String audioName;
    protected InputStream audioResource;
    protected String contentType;
    protected String containedContentType;
    protected Boolean allowOverwrite;

    protected AddAudioOptions() {
    }

    protected AddAudioOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notEmpty((String)builder.audioName, (String)"audioName cannot be empty");
        Validator.notNull((Object)builder.audioResource, (String)"audioResource cannot be null");
        this.customizationId = builder.customizationId;
        this.audioName = builder.audioName;
        this.audioResource = builder.audioResource;
        this.contentType = builder.contentType;
        this.containedContentType = builder.containedContentType;
        this.allowOverwrite = builder.allowOverwrite;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String audioName() {
        return this.audioName;
    }

    public InputStream audioResource() {
        return this.audioResource;
    }

    public String contentType() {
        return this.contentType;
    }

    public String containedContentType() {
        return this.containedContentType;
    }

    public Boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public static class Builder {
        private String customizationId;
        private String audioName;
        private InputStream audioResource;
        private String contentType;
        private String containedContentType;
        private Boolean allowOverwrite;

        private Builder(AddAudioOptions addAudioOptions) {
            this.customizationId = addAudioOptions.customizationId;
            this.audioName = addAudioOptions.audioName;
            this.audioResource = addAudioOptions.audioResource;
            this.contentType = addAudioOptions.contentType;
            this.containedContentType = addAudioOptions.containedContentType;
            this.allowOverwrite = addAudioOptions.allowOverwrite;
        }

        public Builder() {
        }

        public Builder(String customizationId, String audioName, InputStream audioResource) {
            this.customizationId = customizationId;
            this.audioName = audioName;
            this.audioResource = audioResource;
        }

        public AddAudioOptions build() {
            return new AddAudioOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder audioName(String audioName) {
            this.audioName = audioName;
            return this;
        }

        public Builder audioResource(InputStream audioResource) {
            this.audioResource = audioResource;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder containedContentType(String containedContentType) {
            this.containedContentType = containedContentType;
            return this;
        }

        public Builder allowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public Builder audioResource(File audioResource) throws FileNotFoundException {
            this.audioResource = new FileInputStream(audioResource);
            return this;
        }
    }

    public static interface ContainedContentType {
        public static final String AUDIO_ALAW = "audio/alaw";
        public static final String AUDIO_BASIC = "audio/basic";
        public static final String AUDIO_FLAC = "audio/flac";
        public static final String AUDIO_G729 = "audio/g729";
        public static final String AUDIO_L16 = "audio/l16";
        public static final String AUDIO_MP3 = "audio/mp3";
        public static final String AUDIO_MPEG = "audio/mpeg";
        public static final String AUDIO_MULAW = "audio/mulaw";
        public static final String AUDIO_OGG = "audio/ogg";
        public static final String AUDIO_OGG_CODECS_OPUS = "audio/ogg;codecs=opus";
        public static final String AUDIO_OGG_CODECS_VORBIS = "audio/ogg;codecs=vorbis";
        public static final String AUDIO_WAV = "audio/wav";
        public static final String AUDIO_WEBM = "audio/webm";
        public static final String AUDIO_WEBM_CODECS_OPUS = "audio/webm;codecs=opus";
        public static final String AUDIO_WEBM_CODECS_VORBIS = "audio/webm;codecs=vorbis";
    }
}

