/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class DetectLanguageOptions
extends GenericModel {
    protected Float lidConfidence;
    protected InputStream audio;
    protected String contentType;

    protected DetectLanguageOptions() {
    }

    protected DetectLanguageOptions(Builder builder) {
        Validator.notNull((Object)builder.lidConfidence, (String)"lidConfidence cannot be null");
        Validator.notNull((Object)builder.audio, (String)"audio cannot be null");
        this.lidConfidence = builder.lidConfidence;
        this.audio = builder.audio;
        this.contentType = builder.contentType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Float lidConfidence() {
        return this.lidConfidence;
    }

    public InputStream audio() {
        return this.audio;
    }

    public String contentType() {
        return this.contentType;
    }

    public static class Builder {
        private Float lidConfidence;
        private InputStream audio;
        private String contentType;

        private Builder(DetectLanguageOptions detectLanguageOptions) {
            this.lidConfidence = detectLanguageOptions.lidConfidence;
            this.audio = detectLanguageOptions.audio;
            this.contentType = detectLanguageOptions.contentType;
        }

        public Builder() {
        }

        public Builder(Float lidConfidence, InputStream audio) {
            this.lidConfidence = lidConfidence;
            this.audio = audio;
        }

        public DetectLanguageOptions build() {
            return new DetectLanguageOptions(this);
        }

        public Builder lidConfidence(Float lidConfidence) {
            this.lidConfidence = lidConfidence;
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }
    }
}

