/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.text_to_speech.v1.model.AddCustomPromptOptions;
import com.ibm.watson.text_to_speech.v1.model.AddWordOptions;
import com.ibm.watson.text_to_speech.v1.model.AddWordsOptions;
import com.ibm.watson.text_to_speech.v1.model.CreateCustomModelOptions;
import com.ibm.watson.text_to_speech.v1.model.CreateSpeakerModelOptions;
import com.ibm.watson.text_to_speech.v1.model.CustomModel;
import com.ibm.watson.text_to_speech.v1.model.CustomModels;
import com.ibm.watson.text_to_speech.v1.model.DeleteCustomModelOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteCustomPromptOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteSpeakerModelOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteUserDataOptions;
import com.ibm.watson.text_to_speech.v1.model.DeleteWordOptions;
import com.ibm.watson.text_to_speech.v1.model.GetCustomModelOptions;
import com.ibm.watson.text_to_speech.v1.model.GetCustomPromptOptions;
import com.ibm.watson.text_to_speech.v1.model.GetPronunciationOptions;
import com.ibm.watson.text_to_speech.v1.model.GetSpeakerModelOptions;
import com.ibm.watson.text_to_speech.v1.model.GetVoiceOptions;
import com.ibm.watson.text_to_speech.v1.model.GetWordOptions;
import com.ibm.watson.text_to_speech.v1.model.ListCustomModelsOptions;
import com.ibm.watson.text_to_speech.v1.model.ListCustomPromptsOptions;
import com.ibm.watson.text_to_speech.v1.model.ListSpeakerModelsOptions;
import com.ibm.watson.text_to_speech.v1.model.ListVoicesOptions;
import com.ibm.watson.text_to_speech.v1.model.ListWordsOptions;
import com.ibm.watson.text_to_speech.v1.model.Prompt;
import com.ibm.watson.text_to_speech.v1.model.Prompts;
import com.ibm.watson.text_to_speech.v1.model.Pronunciation;
import com.ibm.watson.text_to_speech.v1.model.SpeakerCustomModels;
import com.ibm.watson.text_to_speech.v1.model.SpeakerModel;
import com.ibm.watson.text_to_speech.v1.model.Speakers;
import com.ibm.watson.text_to_speech.v1.model.SynthesizeOptions;
import com.ibm.watson.text_to_speech.v1.model.Translation;
import com.ibm.watson.text_to_speech.v1.model.UpdateCustomModelOptions;
import com.ibm.watson.text_to_speech.v1.model.Voice;
import com.ibm.watson.text_to_speech.v1.model.Voices;
import com.ibm.watson.text_to_speech.v1.model.Words;
import com.ibm.watson.text_to_speech.v1.websocket.SynthesizeCallback;
import com.ibm.watson.text_to_speech.v1.websocket.TextToSpeechWebSocketListener;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class TextToSpeech
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "text_to_speech";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.text-to-speech.watson.cloud.ibm.com";

    public TextToSpeech() {
        this(DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public TextToSpeech(Authenticator authenticator) {
        this(DEFAULT_SERVICE_NAME, authenticator);
    }

    public TextToSpeech(String serviceName) {
        this(serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public TextToSpeech(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.configureService(serviceName);
    }

    public WebSocket synthesizeUsingWebSocket(SynthesizeOptions synthesizeOptions, SynthesizeCallback callback) {
        Validator.notNull((Object)((Object)synthesizeOptions), (String)"synthesizeOptions cannot be null");
        Validator.notNull((Object)callback, (String)"callback cannot be null");
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(this.getServiceUrl() + "/v1/synthesize")).newBuilder();
        if (synthesizeOptions.voice() != null) {
            urlBuilder.addQueryParameter("voice", synthesizeOptions.voice());
        }
        if (synthesizeOptions.customizationId() != null) {
            urlBuilder.addQueryParameter("customization_id", synthesizeOptions.customizationId());
        }
        String url = urlBuilder.toString().replace("https://", "wss://");
        Request.Builder builder = new Request.Builder().url(url);
        this.setAuthentication(builder);
        this.setDefaultHeaders(builder);
        OkHttpClient client = this.configureHttpClient();
        return client.newWebSocket(builder.build(), (WebSocketListener)new TextToSpeechWebSocketListener(synthesizeOptions, callback));
    }

    public ServiceCall<Voices> listVoices(ListVoicesOptions listVoicesOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/voices"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listVoices");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Voices>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Voices> listVoices() {
        return this.listVoices(null);
    }

    public ServiceCall<Voice> getVoice(GetVoiceOptions getVoiceOptions) {
        Validator.notNull((Object)((Object)getVoiceOptions), (String)"getVoiceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("voice", getVoiceOptions.voice());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/voices/{voice}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getVoice");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getVoiceOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", String.valueOf(getVoiceOptions.customizationId())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Voice>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> synthesize(SynthesizeOptions synthesizeOptions) {
        Validator.notNull((Object)((Object)synthesizeOptions), (String)"synthesizeOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/synthesize"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"synthesize");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (synthesizeOptions.accept() != null) {
            builder.header(new Object[]{"Accept", synthesizeOptions.accept()});
        }
        if (synthesizeOptions.voice() != null) {
            builder.query(new Object[]{"voice", String.valueOf(synthesizeOptions.voice())});
        }
        if (synthesizeOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", String.valueOf(synthesizeOptions.customizationId())});
        }
        if (synthesizeOptions.spellOutMode() != null) {
            builder.query(new Object[]{"spell_out_mode", String.valueOf(synthesizeOptions.spellOutMode())});
        }
        if (synthesizeOptions.ratePercentage() != null) {
            builder.query(new Object[]{"rate_percentage", String.valueOf(synthesizeOptions.ratePercentage())});
        }
        if (synthesizeOptions.pitchPercentage() != null) {
            builder.query(new Object[]{"pitch_percentage", String.valueOf(synthesizeOptions.pitchPercentage())});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", synthesizeOptions.text());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Pronunciation> getPronunciation(GetPronunciationOptions getPronunciationOptions) {
        Validator.notNull((Object)((Object)getPronunciationOptions), (String)"getPronunciationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/pronunciation"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getPronunciation");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"text", String.valueOf(getPronunciationOptions.text())});
        if (getPronunciationOptions.voice() != null) {
            builder.query(new Object[]{"voice", String.valueOf(getPronunciationOptions.voice())});
        }
        if (getPronunciationOptions.format() != null) {
            builder.query(new Object[]{"format", String.valueOf(getPronunciationOptions.format())});
        }
        if (getPronunciationOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", String.valueOf(getPronunciationOptions.customizationId())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Pronunciation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CustomModel> createCustomModel(CreateCustomModelOptions createCustomModelOptions) {
        Validator.notNull((Object)((Object)createCustomModelOptions), (String)"createCustomModelOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createCustomModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createCustomModelOptions.name());
        if (createCustomModelOptions.language() != null) {
            contentJson.addProperty("language", createCustomModelOptions.language());
        }
        if (createCustomModelOptions.description() != null) {
            contentJson.addProperty("description", createCustomModelOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CustomModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CustomModels> listCustomModels(ListCustomModelsOptions listCustomModelsOptions) {
        if (listCustomModelsOptions == null) {
            listCustomModelsOptions = new ListCustomModelsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listCustomModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listCustomModelsOptions.language() != null) {
            builder.query(new Object[]{"language", String.valueOf(listCustomModelsOptions.language())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CustomModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CustomModels> listCustomModels() {
        return this.listCustomModels(null);
    }

    public ServiceCall<Void> updateCustomModel(UpdateCustomModelOptions updateCustomModelOptions) {
        Validator.notNull((Object)((Object)updateCustomModelOptions), (String)"updateCustomModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", updateCustomModelOptions.customizationId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateCustomModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (updateCustomModelOptions.name() != null) {
            contentJson.addProperty("name", updateCustomModelOptions.name());
        }
        if (updateCustomModelOptions.description() != null) {
            contentJson.addProperty("description", updateCustomModelOptions.description());
        }
        if (updateCustomModelOptions.words() != null) {
            contentJson.add("words", GsonSingleton.getGson().toJsonTree(updateCustomModelOptions.words()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CustomModel> getCustomModel(GetCustomModelOptions getCustomModelOptions) {
        Validator.notNull((Object)((Object)getCustomModelOptions), (String)"getCustomModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", getCustomModelOptions.customizationId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCustomModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CustomModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCustomModel(DeleteCustomModelOptions deleteCustomModelOptions) {
        Validator.notNull((Object)((Object)deleteCustomModelOptions), (String)"deleteCustomModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", deleteCustomModelOptions.customizationId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteCustomModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWords(AddWordsOptions addWordsOptions) {
        Validator.notNull((Object)((Object)addWordsOptions), (String)"addWordsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", addWordsOptions.customizationId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/words", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("words", GsonSingleton.getGson().toJsonTree(addWordsOptions.words()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Words> listWords(ListWordsOptions listWordsOptions) {
        Validator.notNull((Object)((Object)listWordsOptions), (String)"listWordsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", listWordsOptions.customizationId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/words", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Words>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWord(AddWordOptions addWordOptions) {
        Validator.notNull((Object)((Object)addWordOptions), (String)"addWordOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", addWordOptions.customizationId());
        pathParamsMap.put("word", addWordOptions.word());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/words/{word}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("translation", addWordOptions.translation());
        if (addWordOptions.partOfSpeech() != null) {
            contentJson.addProperty("part_of_speech", addWordOptions.partOfSpeech());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Translation> getWord(GetWordOptions getWordOptions) {
        Validator.notNull((Object)((Object)getWordOptions), (String)"getWordOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", getWordOptions.customizationId());
        pathParamsMap.put("word", getWordOptions.word());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/words/{word}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Translation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteWord(DeleteWordOptions deleteWordOptions) {
        Validator.notNull((Object)((Object)deleteWordOptions), (String)"deleteWordOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", deleteWordOptions.customizationId());
        pathParamsMap.put("word", deleteWordOptions.word());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/words/{word}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Prompts> listCustomPrompts(ListCustomPromptsOptions listCustomPromptsOptions) {
        Validator.notNull((Object)((Object)listCustomPromptsOptions), (String)"listCustomPromptsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", listCustomPromptsOptions.customizationId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/prompts", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listCustomPrompts");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Prompts>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Prompt> addCustomPrompt(AddCustomPromptOptions addCustomPromptOptions) {
        Validator.notNull((Object)((Object)addCustomPromptOptions), (String)"addCustomPromptOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", addCustomPromptOptions.customizationId());
        pathParamsMap.put("prompt_id", addCustomPromptOptions.promptId());
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/prompts/{prompt_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addCustomPrompt");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("metadata", addCustomPromptOptions.metadata().toString());
        RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)addCustomPromptOptions.file(), (String)"audio/wav");
        multipartBuilder.addFormDataPart("file", "filename", fileBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Prompt>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Prompt> getCustomPrompt(GetCustomPromptOptions getCustomPromptOptions) {
        Validator.notNull((Object)((Object)getCustomPromptOptions), (String)"getCustomPromptOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", getCustomPromptOptions.customizationId());
        pathParamsMap.put("prompt_id", getCustomPromptOptions.promptId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/prompts/{prompt_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCustomPrompt");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Prompt>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCustomPrompt(DeleteCustomPromptOptions deleteCustomPromptOptions) {
        Validator.notNull((Object)((Object)deleteCustomPromptOptions), (String)"deleteCustomPromptOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("customization_id", deleteCustomPromptOptions.customizationId());
        pathParamsMap.put("prompt_id", deleteCustomPromptOptions.promptId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/customizations/{customization_id}/prompts/{prompt_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteCustomPrompt");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Speakers> listSpeakerModels(ListSpeakerModelsOptions listSpeakerModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/speakers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listSpeakerModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Speakers>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Speakers> listSpeakerModels() {
        return this.listSpeakerModels(null);
    }

    public ServiceCall<SpeakerModel> createSpeakerModel(CreateSpeakerModelOptions createSpeakerModelOptions) {
        Validator.notNull((Object)((Object)createSpeakerModelOptions), (String)"createSpeakerModelOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/speakers"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createSpeakerModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"speaker_name", String.valueOf(createSpeakerModelOptions.speakerName())});
        builder.bodyContent(createSpeakerModelOptions.audio(), "audio/wav");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SpeakerModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SpeakerCustomModels> getSpeakerModel(GetSpeakerModelOptions getSpeakerModelOptions) {
        Validator.notNull((Object)((Object)getSpeakerModelOptions), (String)"getSpeakerModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("speaker_id", getSpeakerModelOptions.speakerId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/speakers/{speaker_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSpeakerModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SpeakerCustomModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteSpeakerModel(DeleteSpeakerModelOptions deleteSpeakerModelOptions) {
        Validator.notNull((Object)((Object)deleteSpeakerModelOptions), (String)"deleteSpeakerModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("speaker_id", deleteSpeakerModelOptions.speakerId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/speakers/{speaker_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteSpeakerModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/user_data"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"customer_id", String.valueOf(deleteUserDataOptions.customerId())});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

