/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.PartialChatResponse;
import com.ibm.watsonx.ai.chat.model.PartialToolCall;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import com.ibm.watsonx.ai.chat.util.StreamingStateTracker;
import com.ibm.watsonx.ai.chat.util.StreamingToolFetcher;
import com.ibm.watsonx.ai.core.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public interface ChatSubscriber {
    public void onNext(String var1);

    public void onError(Throwable var1);

    public void onComplete();

    public static Map<String, Boolean> toolHasParameters(List<Tool> tools) {
        if (Objects.isNull(tools) || tools.size() == 0) {
            return Map.of();
        }
        return tools.stream().collect(Collectors.toMap(tool -> tool.function().name(), Tool::hasParameters));
    }

    public static Void handleError(Throwable t, ChatHandler handler) {
        Optional.ofNullable(t).map(Throwable::getCause).ifPresent(handler::onError);
        return null;
    }

    public static ChatSubscriber createSubscriber(String toolChoiceOption, final Map<String, Boolean> toolHasParameters, final ExtractionTags extractionTags, final ChatHandler handler) {
        return new ChatSubscriber(){
            private volatile String completionId;
            private volatile String finishReason;
            private volatile String role;
            private volatile String refusal;
            private volatile boolean pendingSSEError = false;
            private final StringBuffer contentBuffer = new StringBuffer();
            private final StringBuffer thinkingBuffer = new StringBuffer();
            private final ChatResponse chatResponse = new ChatResponse();
            private final List<StreamingToolFetcher> tools = Collections.synchronizedList(new ArrayList());
            private final StreamingStateTracker stateTracker = Objects.nonNull(extractionTags) ? new StreamingStateTracker(extractionTags) : null;
            private final ReentrantLock callbackLock = new ReentrantLock();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                String token;
                if (Objects.isNull(partialMessage) || partialMessage.isBlank()) {
                    return;
                }
                if (partialMessage.startsWith("event: error")) {
                    this.pendingSSEError = true;
                    return;
                }
                if (partialMessage.startsWith("event: close")) {
                    return;
                }
                if (!partialMessage.startsWith("data:")) {
                    return;
                }
                String messageData = partialMessage.split("data: ")[1];
                if (this.pendingSSEError) {
                    this.pendingSSEError = false;
                    throw new RuntimeException(messageData);
                }
                PartialChatResponse chunk = (PartialChatResponse)Json.fromJson((String)messageData, PartialChatResponse.class);
                ChatResponse chatResponse = this.chatResponse;
                synchronized (chatResponse) {
                    if (chunk.choices().size() == 0) {
                        this.chatResponse.setUsage(chunk.usage());
                        return;
                    }
                }
                PartialChatResponse.ResultChoice message = chunk.choices().get(0);
                ChatResponse chatResponse2 = this.chatResponse;
                synchronized (chatResponse2) {
                    if (Objects.isNull(this.chatResponse.getCreated()) && Objects.nonNull(chunk.created())) {
                        this.chatResponse.setCreated(chunk.created());
                    }
                    if (Objects.isNull(this.chatResponse.getCreatedAt()) && Objects.nonNull(chunk.createdAt())) {
                        this.chatResponse.setCreatedAt(chunk.createdAt());
                    }
                    if (Objects.isNull(this.chatResponse.getId()) && Objects.nonNull(chunk.id())) {
                        this.chatResponse.setId(chunk.id());
                        this.completionId = chunk.id();
                    }
                    if (Objects.isNull(this.chatResponse.getModelId()) && Objects.nonNull(chunk.modelId())) {
                        this.chatResponse.setModelId(chunk.modelId());
                    }
                    if (Objects.isNull(this.chatResponse.getObject()) && Objects.nonNull(chunk.object())) {
                        this.chatResponse.setObject(chunk.object());
                    }
                    if (Objects.isNull(this.chatResponse.getModelVersion()) && Objects.nonNull(chunk.modelVersion())) {
                        this.chatResponse.setModelVersion(chunk.modelVersion());
                    }
                    if (Objects.isNull(this.chatResponse.getModel()) && Objects.nonNull(chunk.model())) {
                        this.chatResponse.setModel(chunk.model());
                    }
                    if (Objects.isNull(this.finishReason) && Objects.nonNull(message.finishReason())) {
                        this.finishReason = message.finishReason();
                    }
                    if (Objects.isNull(this.role) && Objects.nonNull(message.delta().role())) {
                        this.role = message.delta().role();
                    }
                    if (Objects.isNull(this.refusal) && Objects.nonNull(message.delta().refusal())) {
                        this.refusal = message.delta().refusal();
                    }
                }
                if (message.delta().toolCalls() != null) {
                    StreamingToolFetcher toolFetcher;
                    this.finishReason = "tool_calls";
                    ToolCall deltaTool = message.delta().toolCalls().get(0);
                    Integer index = deltaTool.index();
                    if (index + 1 > this.tools.size()) {
                        toolFetcher = new StreamingToolFetcher(index);
                        this.tools.add(toolFetcher);
                        if (index - 1 >= 0) {
                            ToolCall tool = this.tools.get(index - 1).build();
                            try {
                                this.callbackLock.lock();
                                handler.onCompleteToolCall(new CompletedToolCall(this.completionId, tool));
                            }
                            finally {
                                this.callbackLock.unlock();
                            }
                        }
                    } else {
                        toolFetcher = this.tools.get(index);
                    }
                    toolFetcher.setId(deltaTool.id());
                    if (Objects.nonNull(deltaTool.function())) {
                        String arguments;
                        toolFetcher.setName(deltaTool.function().name());
                        toolFetcher.appendArguments(deltaTool.function().arguments());
                        Boolean toolHasParameter = (Boolean)toolHasParameters.get(toolFetcher.getName());
                        String string = arguments = Objects.isNull(toolHasParameter) || toolHasParameter != false ? deltaTool.function().arguments() : "{}";
                        if (!arguments.isEmpty()) {
                            PartialToolCall partialToolCall = new PartialToolCall(this.completionId, toolFetcher.getIndex(), toolFetcher.getId(), toolFetcher.getName(), arguments);
                            try {
                                this.callbackLock.lock();
                                handler.onPartialToolCall(partialToolCall);
                            }
                            finally {
                                this.callbackLock.unlock();
                            }
                        }
                    }
                }
                if (Objects.nonNull(message.delta().content())) {
                    token = message.delta().content();
                    if (token.isEmpty()) {
                        return;
                    }
                    this.contentBuffer.append(token);
                    if (Objects.nonNull(this.stateTracker)) {
                        StreamingStateTracker.Result r = this.stateTracker.update(token);
                        Optional<String> content = r.content();
                        switch (r.state()) {
                            case RESPONSE: 
                            case NO_THINKING: {
                                content.ifPresent(c -> {
                                    try {
                                        this.callbackLock.lock();
                                        handler.onPartialResponse((String)c, chunk);
                                    }
                                    finally {
                                        this.callbackLock.unlock();
                                    }
                                });
                                break;
                            }
                            case THINKING: {
                                content.ifPresent(c -> {
                                    this.thinkingBuffer.append((String)c);
                                    try {
                                        this.callbackLock.lock();
                                        handler.onPartialThinking((String)c, chunk);
                                    }
                                    finally {
                                        this.callbackLock.unlock();
                                    }
                                });
                                break;
                            }
                        }
                    } else {
                        try {
                            this.callbackLock.lock();
                            handler.onPartialResponse(token, chunk);
                        }
                        finally {
                            this.callbackLock.unlock();
                        }
                    }
                }
                if (Objects.nonNull(message.delta().reasoningContent())) {
                    token = message.delta().reasoningContent();
                    if (token.isEmpty()) {
                        return;
                    }
                    this.thinkingBuffer.append(token);
                    try {
                        this.callbackLock.lock();
                        handler.onPartialThinking(token, chunk);
                    }
                    finally {
                        this.callbackLock.unlock();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                try {
                    this.callbackLock.lock();
                    handler.onError(throwable);
                }
                finally {
                    this.callbackLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                try {
                    List<ToolCall> toolCalls = null;
                    String content = this.contentBuffer.toString();
                    String thinking = this.thinkingBuffer.toString();
                    if (Objects.nonNull(this.finishReason) && this.finishReason.equals("tool_calls")) {
                        content = null;
                        toolCalls = this.tools.stream().map(StreamingToolFetcher::build).toList();
                        try {
                            this.callbackLock.lock();
                            handler.onCompleteToolCall(new CompletedToolCall(this.completionId, toolCalls.get(toolCalls.size() - 1)));
                        }
                        finally {
                            this.callbackLock.unlock();
                        }
                    }
                    ResultMessage resultMessage = new ResultMessage(this.role, content, thinking, this.refusal, toolCalls);
                    ChatResponse chatResponse = this.chatResponse;
                    synchronized (chatResponse) {
                        this.chatResponse.setExtractionTags(extractionTags);
                        this.chatResponse.setChoices(List.of(new ChatResponse.ResultChoice(0, resultMessage, this.finishReason)));
                    }
                    try {
                        this.callbackLock.lock();
                        handler.onCompleteResponse(this.chatResponse);
                    }
                    finally {
                        this.callbackLock.unlock();
                    }
                }
                catch (RuntimeException e) {
                    this.onError(e);
                }
            }
        };
    }
}

