/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public final class ChatParameters
extends WatsonxParameters.WatsonxModelParameters {
    private final String toolChoiceOption;
    private final Map<String, Object> toolChoice;
    private final Set<String> guidedChoice;
    private final String guidedRegex;
    private final String guidedGrammar;
    private final Double frequencyPenalty;
    private final Map<String, Integer> logitBias;
    private final Boolean logprobs;
    private final Integer topLogprobs;
    private final Integer maxCompletionTokens;
    private final Integer n;
    private final Double presencePenalty;
    private final Integer seed;
    private final List<String> stop;
    private final Double temperature;
    private final Double topP;
    private final Long timeLimit;
    private final String responseFormat;
    private final JsonSchemaObject jsonSchema;
    private final Float repetitionPenalty;
    private final Float lengthPenalty;
    private final String context;

    public ChatParameters(Builder builder) {
        super(builder);
        this.toolChoiceOption = Objects.nonNull((Object)builder.toolChoiceOption) ? builder.toolChoiceOption.type() : null;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.n = builder.n;
        this.presencePenalty = builder.presencePenalty;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.timeLimit = builder.timeLimit;
        this.seed = builder.seed;
        this.stop = builder.stop;
        this.context = builder.context;
        if (Objects.nonNull((Object)builder.responseFormat)) {
            this.responseFormat = builder.responseFormat.type();
            this.jsonSchema = builder.jsonSchema;
        } else {
            this.responseFormat = null;
            this.jsonSchema = null;
        }
        this.toolChoice = Objects.nonNull(builder.toolChoice) ? Map.of("type", "function", "function", Map.of("name", builder.toolChoice)) : null;
        this.guidedChoice = builder.guidedChoice;
        this.guidedRegex = builder.guidedRegex;
        this.guidedGrammar = builder.guidedGrammar;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.lengthPenalty = builder.lengthPenalty;
    }

    public String getToolChoiceOption() {
        return this.toolChoiceOption;
    }

    public Map<String, Object> getToolChoice() {
        return this.toolChoice;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public JsonSchemaObject getJsonSchema() {
        return this.jsonSchema;
    }

    public Set<String> getGuidedChoice() {
        return this.guidedChoice;
    }

    public String getGuidedRegex() {
        return this.guidedRegex;
    }

    public String getGuidedGrammar() {
        return this.guidedGrammar;
    }

    public Float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Float getLengthPenalty() {
        return this.lengthPenalty;
    }

    public String getContext() {
        return this.context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.WatsonxModelParameters.Builder<Builder> {
        private ToolChoiceOption toolChoiceOption;
        private String toolChoice;
        private Set<String> guidedChoice;
        private String guidedRegex;
        private String guidedGrammar;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxCompletionTokens;
        private Integer n;
        private Double presencePenalty;
        private ResponseFormat responseFormat;
        private Integer seed;
        private List<String> stop;
        private Double temperature;
        private Double topP;
        private Long timeLimit;
        private JsonSchemaObject jsonSchema;
        private Float repetitionPenalty;
        private Float lengthPenalty;
        private String context;

        private Builder() {
        }

        public Builder toolChoiceOption(ToolChoiceOption toolChoiceOption) {
            this.toolChoiceOption = toolChoiceOption;
            return this;
        }

        public Builder guidedChoice(String ... guidedChoice) {
            return this.guidedChoice(Set.of(guidedChoice));
        }

        public Builder guidedChoice(Set<String> guidedChoices) {
            this.guidedChoice = guidedChoices;
            return this;
        }

        public Builder guidedRegex(String guidedRegex) {
            this.guidedRegex = guidedRegex;
            return this;
        }

        public Builder guidedGrammar(String guidedGrammar) {
            this.guidedGrammar = guidedGrammar;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder logprobs(Boolean logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder topLogprobs(Integer topLogprobs) {
            this.topLogprobs = topLogprobs;
            return this;
        }

        public Builder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public Builder n(Integer n) {
            this.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder timeLimit(Duration timeLimit) {
            this.timeLimit = Objects.isNull(timeLimit) ? null : Long.valueOf(timeLimit.toMillis());
            return this;
        }

        public Builder responseAsText() {
            this.responseFormat = ResponseFormat.TEXT;
            return this;
        }

        public Builder responseAsJson() {
            this.responseFormat = ResponseFormat.JSON;
            return this;
        }

        public Builder responseAsJsonSchema(JsonSchema schema) {
            return this.responseAsJsonSchema(UUID.randomUUID().toString(), schema, true);
        }

        public Builder responseAsJsonSchema(String name, JsonSchema schema, boolean strict) {
            this.responseFormat = ResponseFormat.JSON_SCHEMA;
            this.jsonSchema = new JsonSchemaObject(name, schema, strict);
            return this;
        }

        public Builder responseAsJsonSchema(String name, Map<String, Object> schema, boolean strict) {
            this.responseFormat = ResponseFormat.JSON_SCHEMA;
            this.jsonSchema = new JsonSchemaObject(name, schema, strict);
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public Builder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public Builder lengthPenalty(Float lengthPenalty) {
            this.lengthPenalty = lengthPenalty;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public ChatParameters build() {
            return new ChatParameters(this);
        }
    }

    public static enum ToolChoiceOption {
        AUTO("auto"),
        REQUIRED("required"),
        NONE("none");

        private final String type;

        private ToolChoiceOption(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }

    public static enum ResponseFormat {
        TEXT("text"),
        JSON("json_object"),
        JSON_SCHEMA("json_schema");

        private final String type;

        private ResponseFormat(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }
    }

    public record JsonSchemaObject(String name, Object schema, boolean strict) {
    }
}

