/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.Tool;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class TextChatRequest {
    private final String modelId;
    private final String spaceId;
    private final String projectId;
    private final List<ChatMessage> messages;
    private final List<Tool> tools;
    private final String toolChoiceOption;
    private final Map<String, Object> toolChoice;
    private final Double frequencyPenalty;
    private final Map<String, Integer> logitBias;
    private final Boolean logprobs;
    private final Integer topLogprobs;
    private final Integer maxCompletionTokens;
    private final Integer n;
    private final Double presencePenalty;
    private final Integer seed;
    private final List<String> stop;
    private final Double temperature;
    private final Double topP;
    private final Long timeLimit;
    private final Map<String, Object> responseFormat;
    private final Map<String, Object> chatTemplateKwargs;
    private final Boolean includeReasoning;
    private final String reasoningEffort;
    private final Set<String> guidedChoice;
    private final String guidedRegex;
    private final String guidedGrammar;
    private final Float repetitionPenalty;
    private final Float lengthPenalty;
    private final String context;

    private TextChatRequest(Builder builder) {
        this.modelId = builder.modelId;
        this.spaceId = builder.spaceId;
        this.projectId = builder.projectId;
        this.messages = builder.messages;
        this.tools = builder.tools;
        this.toolChoiceOption = builder.toolChoiceOption;
        this.toolChoice = builder.toolChoice;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.logitBias = builder.logitBias;
        this.logprobs = builder.logprobs;
        this.topLogprobs = builder.topLogprobs;
        this.maxCompletionTokens = builder.maxCompletionTokens;
        this.n = builder.n;
        this.presencePenalty = builder.presencePenalty;
        this.seed = builder.seed;
        this.stop = builder.stop;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.timeLimit = builder.timeLimit;
        this.context = builder.context;
        this.chatTemplateKwargs = builder.chatTemplateKwargs;
        this.includeReasoning = builder.includeReasoning;
        this.reasoningEffort = builder.reasoningEffort;
        this.responseFormat = Objects.nonNull(builder.responseFormat) ? (builder.responseFormat.equals(ChatParameters.ResponseFormat.JSON_SCHEMA.type()) ? Map.of("type", builder.responseFormat, "json_schema", builder.jsonSchema) : Map.of("type", builder.responseFormat)) : null;
        this.guidedChoice = builder.guidedChoice;
        this.guidedRegex = builder.guidedRegex;
        this.guidedGrammar = builder.guidedGrammar;
        this.repetitionPenalty = builder.repetitionPenalty;
        this.lengthPenalty = builder.lengthPenalty;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public String getToolChoiceOption() {
        return this.toolChoiceOption;
    }

    public Map<String, Object> getToolChoice() {
        return this.toolChoice;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public Boolean getLogprobs() {
        return this.logprobs;
    }

    public Integer getTopLogprobs() {
        return this.topLogprobs;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    public Map<String, Object> getResponseFormat() {
        return this.responseFormat;
    }

    public String getContext() {
        return this.context;
    }

    public Map<String, Object> getChatTemplateKwargs() {
        return this.chatTemplateKwargs;
    }

    public Boolean getIncludeReasoning() {
        return this.includeReasoning;
    }

    public String getReasoningEffort() {
        return this.reasoningEffort;
    }

    public Set<String> getGuidedChoice() {
        return this.guidedChoice;
    }

    public String getGuidedRegex() {
        return this.guidedRegex;
    }

    public String getGuidedGrammar() {
        return this.guidedGrammar;
    }

    public Float getRepetitionPenalty() {
        return this.repetitionPenalty;
    }

    public Float getLengthPenalty() {
        return this.lengthPenalty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String modelId;
        private String spaceId;
        private String projectId;
        private List<ChatMessage> messages;
        private List<Tool> tools;
        private String toolChoiceOption;
        private Map<String, Object> toolChoice;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Boolean logprobs;
        private Integer topLogprobs;
        private Integer maxCompletionTokens;
        private Integer n;
        private Double presencePenalty;
        private Integer seed;
        private List<String> stop;
        private Double temperature;
        private Double topP;
        private Long timeLimit;
        private String responseFormat;
        private Map<String, Object> chatTemplateKwargs;
        private Boolean includeReasoning;
        private String reasoningEffort;
        private ChatParameters.JsonSchemaObject jsonSchema;
        private Set<String> guidedChoice;
        private String guidedRegex;
        private String guidedGrammar;
        private Float repetitionPenalty;
        private Float lengthPenalty;
        private String context;

        private Builder() {
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder tools(List<Tool> tools) {
            this.tools = tools;
            return this;
        }

        public Builder timeLimit(Long timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder includeReasoning(Boolean includeReasoning) {
            this.includeReasoning = includeReasoning;
            return this;
        }

        public Builder reasoningEffort(String reasoningEffort) {
            this.reasoningEffort = reasoningEffort;
            return this;
        }

        public Builder chatTemplateKwargs(Map<String, Object> chatTemplateKwargs) {
            this.chatTemplateKwargs = chatTemplateKwargs;
            return this;
        }

        public Builder parameters(ChatParameters parameters) {
            this.toolChoiceOption = parameters.getToolChoiceOption();
            this.toolChoice = parameters.getToolChoice();
            this.frequencyPenalty = parameters.getFrequencyPenalty();
            this.logitBias = parameters.getLogitBias();
            this.logprobs = parameters.getLogprobs();
            this.topLogprobs = parameters.getTopLogprobs();
            this.maxCompletionTokens = parameters.getMaxCompletionTokens();
            this.n = parameters.getN();
            this.presencePenalty = parameters.getPresencePenalty();
            this.seed = parameters.getSeed();
            this.stop = parameters.getStop();
            this.temperature = parameters.getTemperature();
            this.topP = parameters.getTopP();
            this.responseFormat = parameters.getResponseFormat();
            this.jsonSchema = parameters.getJsonSchema();
            this.context = parameters.getContext();
            this.timeLimit = parameters.getTimeLimit();
            this.guidedChoice = parameters.getGuidedChoice();
            this.guidedRegex = parameters.getGuidedRegex();
            this.guidedGrammar = parameters.getGuidedGrammar();
            this.repetitionPenalty = parameters.getRepetitionPenalty();
            this.lengthPenalty = parameters.getLengthPenalty();
            return this;
        }

        public TextChatRequest build() {
            return new TextChatRequest(this);
        }
    }
}

