/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.ThinkingEffort;
import java.util.Objects;

public final class Thinking {
    private final Boolean enabled;
    private final Boolean includeReasoning;
    private final ExtractionTags extractionTags;
    private final ThinkingEffort thinkingEffort;

    private Thinking(Builder builder) {
        this.enabled = builder.enabled;
        this.includeReasoning = builder.includeReasoning;
        this.extractionTags = builder.extractionTags;
        this.thinkingEffort = builder.thinkingEffort;
    }

    public Boolean getEnabled() {
        if (Objects.isNull(this.enabled) && (Objects.nonNull(this.includeReasoning) || Objects.nonNull(this.extractionTags) || Objects.nonNull((Object)this.thinkingEffort))) {
            return true;
        }
        return this.enabled;
    }

    public Boolean getIncludeReasoning() {
        return this.includeReasoning;
    }

    public ExtractionTags getExtractionTags() {
        return this.extractionTags;
    }

    public ThinkingEffort getThinkingEffort() {
        return this.thinkingEffort;
    }

    public static Thinking of(ExtractionTags extractionTags) {
        return Thinking.builder().extractionTags(extractionTags).build();
    }

    public static Thinking of(ThinkingEffort thinkingEffort) {
        return Thinking.builder().thinkingEffort(thinkingEffort).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Thinking [enabled=" + this.enabled + ", includeReasoning=" + this.includeReasoning + ", extractionTags=" + String.valueOf(this.extractionTags) + ", thinkingEffort=" + String.valueOf((Object)this.thinkingEffort) + "]";
    }

    public static final class Builder {
        private Boolean enabled;
        private Boolean includeReasoning;
        private ExtractionTags extractionTags;
        private ThinkingEffort thinkingEffort;

        private Builder() {
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder includeReasoning(Boolean includeReasoning) {
            this.includeReasoning = includeReasoning;
            return this;
        }

        public Builder extractionTags(ExtractionTags extractionTags) {
            this.extractionTags = extractionTags;
            return this;
        }

        public Builder thinkingEffort(ThinkingEffort thinkingEffort) {
            this.thinkingEffort = thinkingEffort;
            return this;
        }

        public Thinking build() {
            return new Thinking(this);
        }
    }
}

