/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.util.List;

public final class IntegerSchema
extends JsonSchema {
    private final Integer minimum;
    private final Integer maximum;
    private final Integer exclusiveMinimum;
    private final Integer exclusiveMaximum;

    private IntegerSchema(Builder builder) {
        super(builder.nullable ? List.of("integer", "null") : "integer", builder);
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Integer getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, IntegerSchema> {
        private Integer minimum;
        private Integer maximum;
        private Integer exclusiveMinimum;
        private Integer exclusiveMaximum;

        private Builder() {
        }

        public Builder minimum(int minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder maximum(int maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder exclusiveMinimum(int exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public Builder exclusiveMaximum(int exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        @Override
        public IntegerSchema build() {
            return new IntegerSchema(this);
        }
    }
}

