/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.ArraySchema;
import com.ibm.watsonx.ai.chat.model.schema.BooleanSchema;
import com.ibm.watsonx.ai.chat.model.schema.EnumSchema;
import com.ibm.watsonx.ai.chat.model.schema.IntegerSchema;
import com.ibm.watsonx.ai.chat.model.schema.NumberSchema;
import com.ibm.watsonx.ai.chat.model.schema.ObjectSchema;
import com.ibm.watsonx.ai.chat.model.schema.StringSchema;
import java.util.Arrays;
import java.util.Objects;

public abstract class JsonSchema {
    protected final String description;
    protected final boolean nullable;
    protected final Object type;
    protected final Object constant;

    protected JsonSchema(Object type, Builder<?, ?> builder) {
        this.description = builder.description;
        this.nullable = builder.nullable;
        if (Objects.isNull(builder.constant)) {
            this.type = type;
            this.constant = null;
        } else {
            this.constant = builder.constant;
            this.type = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Object getType() {
        return this.type;
    }

    public Object getConstant() {
        return this.constant;
    }

    public static ObjectSchema.Builder object() {
        return ObjectSchema.builder();
    }

    public static StringSchema.Builder string() {
        return StringSchema.builder();
    }

    public static NumberSchema.Builder number() {
        return NumberSchema.builder();
    }

    public static IntegerSchema.Builder integer() {
        return IntegerSchema.builder();
    }

    public static BooleanSchema.Builder bool() {
        return BooleanSchema.builder();
    }

    public static ArraySchema.Builder array() {
        return ArraySchema.builder();
    }

    public static <T> EnumSchema.Builder enumeration(T ... values) {
        return EnumSchema.builder().values(Arrays.asList(values));
    }

    public static abstract class Builder<B, O extends JsonSchema> {
        protected String description;
        protected boolean nullable = false;
        protected Object constant;

        protected Builder() {
        }

        public B description(String description) {
            this.description = description;
            return (B)this;
        }

        public B nullable() {
            this.nullable = true;
            return (B)this;
        }

        public <T> B constant(T constant) {
            this.constant = constant;
            return (B)this;
        }

        public abstract O build();
    }
}

