/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ObjectSchema
extends JsonSchema {
    private final Map<String, JsonSchema> properties;
    private final List<String> required;
    private final Integer minProperties;
    private final Integer maxProperties;
    private final JsonSchema additionalProperties;

    private ObjectSchema(Builder builder) {
        super(builder.nullable ? List.of("object", "null") : "object", builder);
        this.properties = builder.properties.isEmpty() ? null : builder.properties;
        this.required = builder.required;
        this.minProperties = builder.minProperties;
        this.maxProperties = builder.maxProperties;
        this.additionalProperties = builder.additionalProperties;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public JsonSchema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends JsonSchema.Builder<Builder, ObjectSchema> {
        private Map<String, JsonSchema> properties = new LinkedHashMap<String, JsonSchema>();
        private Integer minProperties;
        private Integer maxProperties;
        private JsonSchema additionalProperties;
        private List<String> required;

        private Builder() {
        }

        public Builder property(String name, JsonSchema.Builder<?, ?> schema) {
            this.properties.put(name, (JsonSchema)schema.build());
            return this;
        }

        public Builder minProperties(int minProperties) {
            this.minProperties = minProperties;
            return this;
        }

        public Builder maxProperties(int maxProperties) {
            this.maxProperties = maxProperties;
            return this;
        }

        public Builder required(String ... required) {
            return this.required(List.of(required));
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        @Override
        public ObjectSchema build() {
            return new ObjectSchema(this);
        }
    }
}

