/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.detection;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.detection.detector.BaseDetector;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class DetectionTextRequest
extends WatsonxParameters {
    private final String input;
    private final Map<String, Map<String, Object>> detectors;

    private DetectionTextRequest(Builder builder) {
        super(builder);
        this.input = Objects.requireNonNull(builder.input, "input cannot be null");
        this.detectors = Objects.requireNonNull(builder.detectors, "detectors cannot be null").stream().collect(Collectors.toMap(BaseDetector::getName, BaseDetector::getProperties));
    }

    public String getInput() {
        return this.input;
    }

    public Map<String, Map<String, Object>> getDetectors() {
        return this.detectors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "DetectionTextRequest [projectId=" + this.projectId + ", spaceId=" + this.spaceId + ", transactionId=" + this.transactionId + ", input=" + this.input + ", detectors=" + String.valueOf(this.detectors) + "]";
    }

    public static final class Builder
    extends WatsonxParameters.Builder<Builder> {
        private String input;
        private List<BaseDetector> detectors;

        private Builder() {
        }

        public Builder input(String input) {
            this.input = input;
            return this;
        }

        public Builder detectors(List<BaseDetector> detectors) {
            this.detectors = detectors;
            return this;
        }

        public Builder detectors(BaseDetector ... detectors) {
            return this.detectors(List.of(detectors));
        }

        public DetectionTextRequest build() {
            return new DetectionTextRequest(this);
        }
    }
}

