/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textgeneration;

import com.ibm.watsonx.ai.textgeneration.Moderation;
import com.ibm.watsonx.ai.textgeneration.TextGenerationParameters;

public final class TextGenerationRequest {
    private final String deploymentId;
    private final String input;
    private final Moderation moderation;
    private final TextGenerationParameters parameters;

    protected TextGenerationRequest(Builder builder) {
        this.input = builder.input;
        this.moderation = builder.moderation;
        this.parameters = builder.parameters;
        this.deploymentId = builder.deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getInput() {
        return this.input;
    }

    public Moderation getModeration() {
        return this.moderation;
    }

    public TextGenerationParameters getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deploymentId;
        private String input;
        private Moderation moderation;
        private TextGenerationParameters parameters;

        private Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder input(String input) {
            this.input = input;
            return this;
        }

        public Builder moderation(Moderation moderation) {
            this.moderation = moderation;
            return this;
        }

        public Builder parameters(TextGenerationParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public TextGenerationRequest build() {
            return new TextGenerationRequest(this);
        }
    }
}

