/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.Map;
import java.util.Objects;

@Experimental
public final class PythonInterpreterTool {
    private final ToolService toolService;
    private final String deploymentId;

    public PythonInterpreterTool(ToolService toolService, String pythonInterpreterDeploymentId) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
        this.deploymentId = pythonInterpreterDeploymentId;
    }

    public String execute(String code) {
        Objects.requireNonNull(code, "code can't be null");
        Map<String, Object> structuredInput = Map.of("code", code);
        Map<String, Object> config = Map.of("deploymentId", this.deploymentId);
        return this.toolService.run(ToolRequest.structuredInput("PythonInterpreter", structuredInput, config));
    }
}

