/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai;

import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.provider.HttpClientProvider;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;

public abstract class WatsonxRestClient {
    public static final String TRANSACTION_ID_HEADER = "X-Global-Transaction-Id";
    protected final String baseUrl;
    protected final String version;
    protected final Duration timeout;
    protected final boolean logRequests;
    protected final boolean logResponses;
    protected final Authenticator authenticator;
    protected final HttpClient httpClient;

    protected WatsonxRestClient(Builder<?, ?> builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "The url must be provided");
        this.version = Objects.requireNonNull(builder.version, "The version must be provided");
        this.timeout = Objects.requireNonNull(builder.timeout, "The timeout must be provided");
        this.authenticator = builder.authenticator;
        this.logRequests = Objects.requireNonNullElse(builder.logRequests, false);
        this.logResponses = Objects.requireNonNullElse(builder.logResponses, false);
        this.httpClient = Objects.requireNonNullElse(builder.httpClient, HttpClientProvider.httpClient((boolean)builder.verifySsl));
    }

    protected static abstract class Builder<T, B extends Builder<T, B>> {
        private String baseUrl;
        private String version;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Authenticator authenticator;
        private HttpClient httpClient;
        private boolean verifySsl = true;

        protected Builder() {
        }

        public abstract T build();

        public B baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (B)this;
        }

        public B version(String version) {
            this.version = version;
            return (B)this;
        }

        public B logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return (B)this;
        }

        public B timeout(Duration timeout) {
            this.timeout = timeout;
            return (B)this;
        }

        public B authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return (B)this;
        }

        public B httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return (B)this;
        }

        public B verifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
            return (B)this;
        }
    }
}

