/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.auth.ibmcloud.IBMCloudAuthenticator;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;

public abstract class WatsonxService {
    protected static final String API_VERSION = "2025-12-05";
    protected static final String TRANSACTION_ID_HEADER = "X-Global-Transaction-Id";
    protected static final Duration TIME_OUT = Duration.ofSeconds(60L);
    protected final String baseUrl;
    protected final String version;
    protected final Duration timeout;
    protected final boolean logRequests;
    protected final boolean logResponses;
    protected final HttpClient httpClient;
    protected final boolean verifySsl;

    protected WatsonxService() {
        this.baseUrl = null;
        this.version = null;
        this.timeout = null;
        this.logRequests = false;
        this.logResponses = false;
        this.httpClient = null;
        this.verifySsl = true;
    }

    protected WatsonxService(Builder<?> builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "The baseUrl must be provided");
        this.version = Objects.requireNonNullElse(builder.version, API_VERSION);
        this.timeout = Objects.requireNonNullElse(builder.timeout, TIME_OUT);
        this.logRequests = Objects.requireNonNullElse(builder.logRequests, false);
        this.logResponses = Objects.requireNonNullElse(builder.logResponses, false);
        this.httpClient = builder.httpClient;
        this.verifySsl = builder.verifySsl;
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private String baseUrl;
        private String version;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private Authenticator authenticator;
        private HttpClient httpClient;
        private boolean verifySsl = true;

        protected Builder() {
        }

        public T baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        public T baseUrl(URI baseUrl) {
            return this.baseUrl(baseUrl.toString());
        }

        public T baseUrl(CloudRegion baseUrl) {
            return this.baseUrl(baseUrl.mlEndpoint());
        }

        public T version(String version) {
            this.version = version;
            return (T)this;
        }

        public T logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return (T)this;
        }

        public T logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return (T)this;
        }

        public T timeout(Duration timeout) {
            this.timeout = timeout;
            return (T)this;
        }

        public T apiKey(String apiKey) {
            Objects.requireNonNull(apiKey, "The apiKey must be provided");
            this.authenticator = IBMCloudAuthenticator.builder().httpClient(this.httpClient).apiKey(apiKey).build();
            return (T)this;
        }

        public T authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return (T)this;
        }

        public T httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return (T)this;
        }

        public T verifySsl(boolean verifySsl) {
            this.verifySsl = verifySsl;
            return (T)this;
        }

        public Authenticator authenticator() {
            return this.authenticator;
        }
    }

    public static abstract class CryptoService
    extends ModelService {
        protected final String crypto;

        protected CryptoService() {
            this.crypto = null;
        }

        protected CryptoService(Builder<?> builder) {
            super((ModelService.Builder<?>)builder);
            this.crypto = builder.crypto;
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends ModelService.Builder<T> {
            private String crypto;

            protected Builder() {
            }

            public T crypto(String crypto) {
                this.crypto = crypto;
                return (T)this;
            }
        }
    }

    public static abstract class ModelService
    extends ProjectService {
        protected final String modelId;

        protected ModelService() {
            this.modelId = null;
        }

        protected ModelService(Builder<?> builder) {
            super((ProjectService.Builder<?>)builder);
            this.modelId = Objects.requireNonNull(builder.modelId, "The modelId must be provided");
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends ProjectService.Builder<T> {
            private String modelId;

            protected Builder() {
            }

            public T modelId(String modelId) {
                this.modelId = modelId;
                return (T)this;
            }
        }
    }

    public static abstract class ProjectService
    extends WatsonxService {
        protected final String projectId;
        protected final String spaceId;

        protected ProjectService() {
            this.projectId = null;
            this.spaceId = null;
        }

        protected ProjectService(Builder<?> builder) {
            super(builder);
            this.projectId = builder.projectId;
            this.spaceId = builder.spaceId;
            if (Objects.isNull(this.projectId) && Objects.isNull(this.spaceId)) {
                throw new NullPointerException("Either projectId or spaceId must be provided");
            }
        }

        protected ProjectSpace resolveProjectSpace(WatsonxParameters parameters) {
            if (Objects.isNull(parameters)) {
                return new ProjectSpace(this.projectId, this.spaceId);
            }
            return Objects.nonNull(parameters.projectId()) || Objects.nonNull(parameters.spaceId()) ? new ProjectSpace(parameters.projectId(), parameters.spaceId()) : new ProjectSpace(this.projectId, this.spaceId);
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends com.ibm.watsonx.ai.WatsonxService$Builder<T> {
            private String projectId;
            private String spaceId;

            protected Builder() {
            }

            public T projectId(String projectId) {
                this.projectId = projectId;
                return (T)this;
            }

            public T spaceId(String spaceId) {
                this.spaceId = spaceId;
                return (T)this;
            }
        }

        protected record ProjectSpace(String projectId, String spaceId) {
        }
    }
}

