/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatProvider;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.interceptor.ToolInterceptor;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;

public class ChatClientContext {
    private final ChatProvider chatProvider;
    private final ChatRequest chatRequest;
    private final ToolInterceptor toolInterceptor;
    private final ExtractionTags extractionTags;

    private ChatClientContext(Builder builder) {
        this.chatProvider = builder.chatProvider;
        this.chatRequest = builder.chatRequest;
        this.toolInterceptor = builder.toolInterceptor;
        this.extractionTags = builder.extractionTags;
    }

    public ChatProvider chatProvider() {
        return this.chatProvider;
    }

    public ChatRequest chatRequest() {
        return this.chatRequest;
    }

    public ToolInterceptor toolInterceptor() {
        return this.toolInterceptor;
    }

    public ExtractionTags extractionTags() {
        return this.extractionTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatProvider chatProvider;
        private ChatRequest chatRequest;
        private ToolInterceptor toolInterceptor;
        private ExtractionTags extractionTags;

        private Builder() {
        }

        public Builder chatProvider(ChatProvider chatProvider) {
            this.chatProvider = chatProvider;
            return this;
        }

        public Builder chatRequest(ChatRequest chatRequest) {
            this.chatRequest = chatRequest;
            return this;
        }

        public Builder toolInterceptor(ToolInterceptor toolInterceptor) {
            this.toolInterceptor = toolInterceptor;
            return this;
        }

        public Builder extractionTags(ExtractionTags extractionTags) {
            this.extractionTags = extractionTags;
            return this;
        }

        public ChatClientContext build() {
            return new ChatClientContext(this);
        }
    }
}

