/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ChatParameters;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.Thinking;
import com.ibm.watsonx.ai.chat.model.ThinkingEffort;
import com.ibm.watsonx.ai.chat.model.Tool;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ChatRequest {
    private final String deploymentId;
    private final List<ChatMessage> messages;
    private final List<Tool> tools;
    private final ChatParameters parameters;
    private final Thinking thinking;

    private ChatRequest(Builder builder) {
        this.messages = Objects.requireNonNull(builder.messages, "messages cannot be null");
        this.tools = builder.tools;
        this.parameters = builder.parameters;
        this.deploymentId = builder.deploymentId;
        this.thinking = builder.thinking;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public List<ChatMessage> messages() {
        return this.messages;
    }

    public List<Tool> tools() {
        return this.tools;
    }

    public ChatParameters parameters() {
        return this.parameters;
    }

    public Thinking thinking() {
        return this.thinking;
    }

    public Builder toBuilder() {
        return new Builder().deploymentId(this.deploymentId).messages(this.messages).parameters(this.parameters).thinking(this.thinking);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String deploymentId;
        private List<ChatMessage> messages;
        private List<Tool> tools;
        private ChatParameters parameters;
        private Thinking thinking;

        private Builder() {
        }

        public Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder messages(ChatMessage ... messages) {
            return this.messages(Arrays.asList(messages));
        }

        public Builder messages(List<? extends ChatMessage> messages) {
            if (Objects.nonNull(messages)) {
                this.messages = new LinkedList<ChatMessage>(messages);
            }
            return this;
        }

        public Builder addMessages(ChatMessage ... messages) {
            return this.addMessages(Arrays.asList(messages));
        }

        public Builder addMessages(List<? extends ChatMessage> messages) {
            if (Objects.isNull(messages) || messages.isEmpty()) {
                return this;
            }
            this.messages = Objects.requireNonNullElse(this.messages, new LinkedList());
            this.messages.addAll(messages);
            return this;
        }

        public Builder tools(ExecutableTool ... executableTools) {
            return this.tools(Arrays.stream(executableTools).map(ExecutableTool::schema).toList());
        }

        public Builder tools(Tool ... tools) {
            return this.tools(List.of(tools));
        }

        public Builder tools(List<Tool> tools) {
            this.tools = Objects.isNull(tools) ? null : List.copyOf(tools);
            return this;
        }

        public Builder parameters(ChatParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder thinking(boolean enabled) {
            return this.thinking(Thinking.builder().enabled(enabled).build());
        }

        public Builder thinking(ExtractionTags tags) {
            if (Objects.isNull(tags)) {
                this.thinking = null;
                return this;
            }
            return this.thinking(Thinking.of(tags));
        }

        public Builder thinking(ThinkingEffort thinkingEffort) {
            if (Objects.isNull((Object)thinkingEffort)) {
                this.thinking = null;
                return this;
            }
            return this.thinking(Thinking.of(thinkingEffort));
        }

        public Builder thinking(Thinking thinking) {
            this.thinking = thinking;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

