/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.model.AssistantMessage;
import com.ibm.watsonx.ai.chat.model.ChatUsage;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.FinishReason;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import java.util.List;
import java.util.Objects;

public final class ChatResponse {
    private final String id;
    private final String object;
    private final String modelId;
    private final String model;
    private final List<ResultChoice> choices;
    private final Long created;
    private final String modelVersion;
    private final String createdAt;
    private final ChatUsage usage;
    private final ExtractionTags extractionTags;

    private ChatResponse(Builder builder) {
        this.id = builder.id;
        this.object = builder.object;
        this.modelId = builder.modelId;
        this.model = builder.model;
        this.choices = Objects.isNull(builder.choices) ? null : List.copyOf(builder.choices);
        this.created = builder.created;
        this.modelVersion = builder.modelVersion;
        this.createdAt = builder.createdAt;
        this.usage = builder.usage;
        this.extractionTags = builder.extractionTags;
    }

    public String id() {
        return this.id;
    }

    public String object() {
        return this.object;
    }

    public String modelId() {
        return this.modelId;
    }

    public String model() {
        return this.model;
    }

    public List<ResultChoice> choices() {
        return this.choices;
    }

    public Long created() {
        return this.created;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public ChatUsage usage() {
        return this.usage;
    }

    public FinishReason finishReason() {
        ResultChoice resultMessage = this.choices.get(0);
        return FinishReason.fromValue(resultMessage.finishReason());
    }

    public List<AssistantMessage> toAssistantMessages() {
        return this.choices.stream().map(ResultChoice::message).map(message -> {
            String thinking;
            String content;
            if (Objects.isNull(this.extractionTags)) {
                content = message.content();
                thinking = message.reasoningContent();
            } else {
                content = this.extractionTags.extractResponse(message.content());
                content = Objects.isNull(content) ? message.content() : content;
                thinking = this.extractionTags.extractThinking(message.content());
            }
            return new AssistantMessage(content, thinking, null, message.refusal(), message.toolCalls());
        }).toList();
    }

    public AssistantMessage toAssistantMessage() {
        return this.toAssistantMessages().get(0);
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).object(this.object).modelId(this.modelId).model(this.model).choices(this.choices).created(this.created).modelVersion(this.modelVersion).createdAt(this.createdAt).usage(this.usage).extractionTags(this.extractionTags);
    }

    public static Builder build() {
        return new Builder();
    }

    public String toString() {
        return "ChatResponse [id=" + this.id + ", object=" + this.object + ", modelId=" + this.modelId + ", model=" + this.model + ", choices=" + String.valueOf(this.choices) + ", created=" + this.created + ", modelVersion=" + this.modelVersion + ", createdAt=" + this.createdAt + ", usage=" + String.valueOf(this.usage) + "]";
    }

    public static class Builder {
        private String id;
        private String object;
        private String modelId;
        private String model;
        private List<ResultChoice> choices;
        private Long created;
        private String modelVersion;
        private String createdAt;
        private ChatUsage usage;
        private ExtractionTags extractionTags;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder choices(List<ResultChoice> choices) {
            this.choices = choices;
            return this;
        }

        public Builder created(Long created) {
            this.created = created;
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder usage(ChatUsage usage) {
            this.usage = usage;
            return this;
        }

        Builder extractionTags(ExtractionTags extractionTags) {
            this.extractionTags = extractionTags;
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this);
        }
    }

    public record ResultChoice(Integer index, ResultMessage message, String finishReason) {
        public ResultChoice withResultMessage(ResultMessage resultMessage) {
            return new ResultChoice(this.index, resultMessage, this.finishReason);
        }

        public ResultChoice withFinishReason(FinishReason finishReason) {
            return new ResultChoice(this.index, this.message, finishReason.value());
        }
    }
}

