/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatClientContext;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.ChatRestClient;
import com.ibm.watsonx.ai.chat.SseEventProcessor;
import com.ibm.watsonx.ai.chat.decorator.ChatHandlerDecorator;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.streaming.ChatSubscriber;
import com.ibm.watsonx.ai.chat.streaming.DefaultChatSubscriber;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class DefaultRestClient
extends ChatRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticator, "authenticator is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public ChatResponse chat(String transactionId, TextChatRequest textChatRequest) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/chat?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(textChatRequest.timeLimit()));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ChatResponse)Json.fromJson((String)((String)httpResponse.body()), ChatResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<ChatResponse> chatStreaming(String transactionId, TextChatRequest textChatRequest, ChatClientContext context, ChatHandler handler) {
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v1/text/chat_stream?version=%s".formatted(this.version))).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(textChatRequest.timeLimit()));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        CompletableFuture<ChatResponse> response = new CompletableFuture<ChatResponse>();
        InterceptorContext interceptorContext = new InterceptorContext(context.chatProvider(), context.chatRequest(), null);
        DefaultChatSubscriber chatSubscriber = new DefaultChatSubscriber(new SseEventProcessor(ChatSubscriber.toolHasParameters(textChatRequest.tools()), context.extractionTags()), new ChatHandlerDecorator(handler, interceptorContext, context.toolInterceptor()));
        Flow.Subscriber<String> subscriber = this.subscriber(chatSubscriber, response, !handler.failOnFirstError());
        ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> {
            response.completeExceptionally(ChatSubscriber.handleError(t, handler));
            return null;
        });
        return response;
    }

    private Flow.Subscriber<String> subscriber(final ChatSubscriber chatSubscriber, final CompletableFuture<ChatResponse> response, final boolean failOnFirstError) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean continueProcessing = true;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                try {
                    chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    Throwable t = Objects.nonNull(e.getCause()) ? e.getCause() : e;
                    this.continueProcessing = failOnFirstError;
                    chatSubscriber.onError(t).whenComplete((v, err) -> {
                        if (!this.continueProcessing) {
                            response.completeExceptionally(t);
                        }
                    });
                }
                finally {
                    if (this.continueProcessing) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                chatSubscriber.onComplete().whenComplete((chatResponse, error) -> {
                    if (Objects.nonNull(error)) {
                        error = Objects.nonNull(error.getCause()) ? error.getCause() : error;
                        chatSubscriber.onError((Throwable)error);
                        response.completeExceptionally((Throwable)error);
                    } else {
                        response.complete(chatResponse);
                    }
                });
            }
        };
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ChatRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

