/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.interceptor;

import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import java.util.List;
import java.util.Objects;

@FunctionalInterface
public interface MessageInterceptor {
    public String intercept(InterceptorContext var1, String var2);

    default public List<ChatResponse.ResultChoice> intercept(InterceptorContext ctx) {
        ChatResponse response = ctx.response().orElseThrow();
        return response.choices().stream().map(choice -> {
            ResultMessage message = choice.message();
            if (Objects.isNull(message.content())) {
                return choice;
            }
            String normalized = this.intercept(ctx, message.content());
            ResultMessage resultMessage = new ResultMessage(message.role(), normalized, message.reasoningContent(), message.refusal(), message.toolCalls());
            return choice.withResultMessage(resultMessage);
        }).toList();
    }
}

