/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.Audio;
import com.ibm.watsonx.ai.chat.model.UserContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;

public record AudioContent(String type, Audio inputAudio) implements UserContent
{
    public static final String TYPE = "input_audio";

    public AudioContent {
        type = TYPE;
        Objects.requireNonNull(inputAudio);
    }

    public static AudioContent from(File file) throws IOException {
        Objects.requireNonNull(file);
        return AudioContent.from(file.toPath());
    }

    public static AudioContent from(Path path) throws IOException {
        Objects.requireNonNull(path);
        String mimetype = Files.probeContentType(path);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            AudioContent audioContent = AudioContent.from(is, mimetype);
            return audioContent;
        }
    }

    public static AudioContent from(InputStream is, String mimetype) throws IOException {
        Objects.requireNonNull(is);
        String data = Base64.getEncoder().encodeToString(is.readAllBytes());
        return AudioContent.of(mimetype, data);
    }

    public static AudioContent of(String format, String data) {
        return new AudioContent(TYPE, new Audio(format, data));
    }
}

