/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.Image;
import com.ibm.watsonx.ai.chat.model.UserContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;

public record ImageContent(String type, Image imageUrl) implements UserContent
{
    public static final String TYPE = "image_url";

    public ImageContent {
        type = TYPE;
        Objects.requireNonNull(imageUrl);
    }

    public static ImageContent from(File file) throws IOException {
        Objects.requireNonNull(file);
        return ImageContent.from(file.toPath());
    }

    public static ImageContent from(Path path) throws IOException {
        Objects.requireNonNull(path);
        String mimetype = Files.probeContentType(path);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            ImageContent imageContent = ImageContent.from(is, mimetype);
            return imageContent;
        }
    }

    public static ImageContent from(InputStream is, String mimetype) throws IOException {
        Objects.requireNonNull(is);
        String data = Base64.getEncoder().encodeToString(is.readAllBytes());
        return ImageContent.of(mimetype, data);
    }

    public static ImageContent of(Image imageUrl) {
        return new ImageContent(TYPE, imageUrl);
    }

    public static ImageContent of(String mimeType, String image) {
        return ImageContent.of(Image.of(mimeType, image, null));
    }

    public static ImageContent of(String mimeType, String image, Image.Detail detail) {
        return ImageContent.of(Image.of(mimeType, image, detail));
    }
}

