/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.ToolExecutor;
import com.ibm.watsonx.ai.chat.model.FunctionCall;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.ToolMessage;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import java.util.Map;
import java.util.Objects;

public record ToolCall(Integer index, String id, String type, FunctionCall function) {
    public static final String TYPE = "function";

    public ToolCall {
        type = TYPE;
    }

    public static ToolCall of(String id, String name, String arguments) {
        return ToolCall.of(null, id, name, arguments);
    }

    public static ToolCall of(Integer index, String id, String name, String arguments) {
        return new ToolCall(index, id, TYPE, FunctionCall.of(name, arguments));
    }

    public ToolCall withFunctionCall(FunctionCall newFunctionCall) {
        return new ToolCall(this.index, this.id, TYPE, newFunctionCall);
    }

    public ToolMessage processTool(ToolExecutor executor) {
        ToolArguments toolArguments = null;
        if (Objects.nonNull(this.function.arguments())) {
            String arguments = this.function.arguments().startsWith("\"") ? (String)Json.fromJson((String)this.function.arguments(), String.class) : this.function.arguments();
            toolArguments = new ToolArguments((Map)Json.fromJson((String)arguments, (TypeToken)new TypeToken<Map<String, Object>>(){}));
        }
        String toolResult = String.valueOf(executor.execute(this.function.name(), toolArguments));
        return ToolMessage.of(toolResult, this.id);
    }
}

