/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.ChatMessage;
import com.ibm.watsonx.ai.chat.model.ImageContent;
import com.ibm.watsonx.ai.chat.model.TextContent;
import com.ibm.watsonx.ai.chat.model.UserContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public record UserMessage(String role, List<UserContent> content, String name) implements ChatMessage
{
    public static final String ROLE = "user";

    public UserMessage {
        role = ROLE;
        Objects.requireNonNull(content, "content must not be null");
    }

    public static UserMessage of(String name, List<UserContent> contents) {
        return new UserMessage(ROLE, contents, name);
    }

    public static UserMessage of(List<UserContent> contents) {
        return UserMessage.of(null, contents);
    }

    public static UserMessage of(UserContent ... contents) {
        return UserMessage.of(Arrays.asList(contents));
    }

    public static UserMessage text(String text) {
        TextContent content = TextContent.of(text);
        return UserMessage.of(null, List.of(content));
    }

    public static UserMessage image(String text, File file) {
        return UserMessage.image(text, file.toPath());
    }

    public static UserMessage image(String text, Path path) {
        UserMessage userMessage;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                String mimeType = Files.probeContentType(path);
                userMessage = UserMessage.image(text, is, mimeType);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return userMessage;
    }

    public static UserMessage image(String text, InputStream is, String mimetype) {
        try {
            return UserMessage.of(null, List.of(TextContent.of(text), ImageContent.from(is, mimetype)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String text() {
        if (this.content.isEmpty()) {
            throw new IllegalStateException("Message contains no content");
        }
        if (this.content.size() > 1) {
            throw new IllegalStateException("Message contains multiple content elements (" + this.content.size() + "). Use content() to access all elements.");
        }
        UserContent firstContent = this.content.get(0);
        if (firstContent instanceof TextContent) {
            TextContent textContent = (TextContent)firstContent;
            return textContent.text();
        }
        throw new IllegalStateException("Message does not contain text content.");
    }
}

