/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.UserContent;
import com.ibm.watsonx.ai.chat.model.Video;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;

public record VideoContent(String type, Video videoUrl) implements UserContent
{
    public static final String TYPE = "video_url";

    public VideoContent {
        type = TYPE;
        Objects.requireNonNull(videoUrl);
    }

    public static VideoContent from(File file) throws IOException {
        Objects.requireNonNull(file);
        return VideoContent.from(file.toPath());
    }

    public static VideoContent from(Path path) throws IOException {
        Objects.requireNonNull(path);
        String mimetype = Files.probeContentType(path);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            VideoContent videoContent = VideoContent.from(is, mimetype);
            return videoContent;
        }
    }

    public static VideoContent from(InputStream is, String mimetype) throws IOException {
        Objects.requireNonNull(is);
        String data = Base64.getEncoder().encodeToString(is.readAllBytes());
        return VideoContent.of(mimetype, data);
    }

    public static VideoContent of(String mimeType, String data) {
        return new VideoContent(TYPE, Video.of(mimeType, data));
    }
}

