/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model.schema;

import com.ibm.watsonx.ai.chat.model.schema.ArraySchema;
import com.ibm.watsonx.ai.chat.model.schema.BooleanSchema;
import com.ibm.watsonx.ai.chat.model.schema.ConstantSchema;
import com.ibm.watsonx.ai.chat.model.schema.EnumSchema;
import com.ibm.watsonx.ai.chat.model.schema.IntegerSchema;
import com.ibm.watsonx.ai.chat.model.schema.NumberSchema;
import com.ibm.watsonx.ai.chat.model.schema.ObjectSchema;
import com.ibm.watsonx.ai.chat.model.schema.RequiredSchema;
import com.ibm.watsonx.ai.chat.model.schema.StringSchema;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class JsonSchema {
    protected final String description;
    protected final boolean nullable;
    protected final Object type;
    protected final List<? extends JsonSchema> oneOf;

    protected JsonSchema(Object type, Builder<?, ?, ?> builder) {
        this.description = builder.description;
        this.nullable = builder.nullable;
        this.oneOf = Objects.nonNull(builder.oneOf) ? builder.oneOf.stream().map(Builder::build).toList() : null;
        this.type = builder.excludeType ? null : type;
    }

    public String description() {
        return this.description;
    }

    public Object type() {
        return this.type;
    }

    public List<? extends JsonSchema> oneOf() {
        return this.oneOf;
    }

    public static RequiredSchema.Builder required(String ... required) {
        return JsonSchema.required(List.of(required));
    }

    public static RequiredSchema.Builder required(List<String> required) {
        return new RequiredSchema.Builder(required);
    }

    public static <T> ConstantSchema.Builder constant(T value) {
        return new ConstantSchema.Builder(value);
    }

    public static ObjectSchema.Builder object() {
        return ObjectSchema.builder();
    }

    public static ObjectSchema.Builder object(String description) {
        return (ObjectSchema.Builder)JsonSchema.object().description(description);
    }

    public static StringSchema.Builder string() {
        return StringSchema.builder();
    }

    public static StringSchema.Builder string(String description) {
        return (StringSchema.Builder)JsonSchema.string().description(description);
    }

    public static NumberSchema.Builder number() {
        return NumberSchema.builder();
    }

    public static NumberSchema.Builder number(String description) {
        return (NumberSchema.Builder)JsonSchema.number().description(description);
    }

    public static IntegerSchema.Builder integer() {
        return IntegerSchema.builder();
    }

    public static IntegerSchema.Builder integer(String description) {
        return (IntegerSchema.Builder)JsonSchema.integer().description(description);
    }

    public static BooleanSchema.Builder bool() {
        return BooleanSchema.builder();
    }

    public static BooleanSchema.Builder bool(String description) {
        return (BooleanSchema.Builder)JsonSchema.bool().description(description);
    }

    public static ArraySchema.Builder array() {
        return ArraySchema.builder();
    }

    public static ArraySchema.Builder array(String description) {
        return (ArraySchema.Builder)JsonSchema.array().description(description);
    }

    public static <T> EnumSchema.Builder enumeration(T ... values) {
        return EnumSchema.builder().values(Arrays.asList(values));
    }

    public static abstract class Builder<B, JS extends JsonSchema, O extends Builder<?, ?, ?>> {
        protected String description;
        protected boolean nullable = false;
        protected List<O> oneOf;
        protected boolean excludeType = false;

        protected Builder() {
        }

        public B description(String description) {
            this.description = description;
            return (B)this;
        }

        public B nullable() {
            this.nullable = true;
            return (B)this;
        }

        public B oneOf(O ... oneOf) {
            return this.oneOf(List.of(oneOf));
        }

        public B oneOf(List<O> oneOf) {
            this.oneOf = oneOf.stream().map(e -> {
                e.description = null;
                e.nullable = false;
                e.oneOf = null;
                e.excludeType = true;
                return e;
            }).toList();
            return (B)this;
        }

        public abstract JS build();
    }
}

