/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.streaming;

import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import java.util.Objects;
import java.util.Optional;

public final class StreamingStateTracker {
    private final String THINKING_START_TAG;
    private final String THINKING_CLOSE_TAG;
    private final String RESPONSE_START_TAG;
    private final String RESPONSE_CLOSE_TAG;
    private final ExtractionTags extractionTags;
    private final StringBuilder tagBuffer;
    private final StringBuilder textBuffer;
    private State currentState = State.START;
    private TagParseState parseState = TagParseState.CONTENT;

    public StreamingStateTracker(ExtractionTags extractionTags) {
        Objects.requireNonNull(extractionTags, "extractionTags cannot be null");
        this.extractionTags = extractionTags;
        this.tagBuffer = new StringBuilder();
        this.textBuffer = new StringBuilder();
        this.THINKING_START_TAG = "<" + extractionTags.think() + ">";
        this.THINKING_CLOSE_TAG = "</" + extractionTags.think() + ">";
        this.RESPONSE_START_TAG = Objects.isNull(extractionTags.response()) ? null : "<" + extractionTags.response() + ">";
        this.RESPONSE_CLOSE_TAG = Objects.isNull(extractionTags.response()) ? null : "</" + extractionTags.response() + ">";
    }

    public synchronized Result update(String chunk) {
        char[] chars;
        if (chunk.isEmpty()) {
            return new Result(this.currentState, Optional.empty());
        }
        chunk = this.decodeUnicodeSymbols(chunk);
        if (this.currentState == State.NO_THINKING) {
            return new Result(this.currentState, Optional.of(chunk));
        }
        block10: for (char c : chars = chunk.toCharArray()) {
            switch (this.parseState) {
                case CONTENT: {
                    if (c == '<') {
                        this.parseState = TagParseState.OPEN_TAG_START;
                        this.tagBuffer.setLength(0);
                        this.tagBuffer.append(c);
                        continue block10;
                    }
                    this.textBuffer.append(c);
                    continue block10;
                }
                case OPEN_TAG_START: {
                    if (c == '/') {
                        this.parseState = TagParseState.CLOSE_TAG_START;
                        this.tagBuffer.append(c);
                        continue block10;
                    }
                    this.parseState = TagParseState.TAG_NAME;
                    this.tagBuffer.append(c);
                    continue block10;
                }
                case CLOSE_TAG_START: 
                case TAG_NAME: {
                    boolean matchesAnyPrefix;
                    this.tagBuffer.append(c);
                    String partialTag = this.tagBuffer.toString();
                    switch (this.currentState) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NO_THINKING: 
                        case START: 
                        case UNKNOWN: {
                            boolean bl = this.startsWithAny(partialTag, this.THINKING_START_TAG, this.THINKING_CLOSE_TAG, this.RESPONSE_START_TAG, this.RESPONSE_CLOSE_TAG);
                            break;
                        }
                        case RESPONSE: {
                            boolean bl = this.startsWithAny(partialTag, this.RESPONSE_CLOSE_TAG);
                            break;
                        }
                        case THINKING: {
                            boolean bl = matchesAnyPrefix = this.startsWithAny(partialTag, this.THINKING_CLOSE_TAG);
                        }
                    }
                    if (!matchesAnyPrefix) {
                        if (this.currentState == State.START) {
                            this.currentState = State.NO_THINKING;
                        }
                        this.parseState = TagParseState.CONTENT;
                        this.textBuffer.append((CharSequence)this.tagBuffer);
                        this.tagBuffer.setLength(0);
                        continue block10;
                    }
                    if (c != '>') continue block10;
                    this.handleCompleteTag(this.tagBuffer.toString());
                    this.tagBuffer.setLength(0);
                    this.parseState = TagParseState.CONTENT;
                }
            }
        }
        String partialTag = this.tagBuffer.toString();
        if (this.currentState == State.START && (partialTag.isEmpty() || partialTag.startsWith(this.THINKING_START_TAG))) {
            this.currentState = State.NO_THINKING;
        }
        String textOut = this.textBuffer.toString();
        this.textBuffer.setLength(0);
        return new Result(this.currentState, textOut.isEmpty() ? Optional.empty() : Optional.of(textOut));
    }

    private void handleCompleteTag(String tag) {
        if (tag.equals(this.THINKING_START_TAG)) {
            this.currentState = State.THINKING;
        } else if (tag.equals(this.THINKING_CLOSE_TAG)) {
            this.currentState = Objects.isNull(this.extractionTags.response()) ? State.RESPONSE : State.UNKNOWN;
        } else if (Objects.isNull(this.RESPONSE_START_TAG) || tag.equals(this.RESPONSE_START_TAG)) {
            this.currentState = State.RESPONSE;
        } else if (Objects.nonNull(this.RESPONSE_CLOSE_TAG) && tag.equals(this.RESPONSE_CLOSE_TAG)) {
            this.currentState = State.UNKNOWN;
        }
    }

    private String decodeUnicodeSymbols(String s) {
        return s.replace("\\u003c", "<").replace("\\u003e", ">");
    }

    private boolean startsWithAny(String prefix, String ... candidates) {
        if (prefix == null) {
            return false;
        }
        for (String candidate : candidates) {
            if (candidate == null || !candidate.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static enum State {
        START,
        THINKING,
        RESPONSE,
        NO_THINKING,
        UNKNOWN;

    }

    private static enum TagParseState {
        CONTENT,
        OPEN_TAG_START,
        CLOSE_TAG_START,
        TAG_NAME;

    }

    public record Result(State state, Optional<String> content) {
    }
}

