/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.deployment;

import com.ibm.watsonx.ai.chat.ChatClientContext;
import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.SseEventProcessor;
import com.ibm.watsonx.ai.chat.decorator.ChatHandlerDecorator;
import com.ibm.watsonx.ai.chat.interceptor.InterceptorContext;
import com.ibm.watsonx.ai.chat.model.TextChatRequest;
import com.ibm.watsonx.ai.chat.streaming.ChatSubscriber;
import com.ibm.watsonx.ai.chat.streaming.DefaultChatSubscriber;
import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.SseEventLogger;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.deployment.DeploymentResource;
import com.ibm.watsonx.ai.deployment.DeploymentRestClient;
import com.ibm.watsonx.ai.deployment.FindByIdRequest;
import com.ibm.watsonx.ai.textgeneration.TextGenerationHandler;
import com.ibm.watsonx.ai.textgeneration.TextGenerationResponse;
import com.ibm.watsonx.ai.textgeneration.TextGenerationSubscriber;
import com.ibm.watsonx.ai.textgeneration.TextRequest;
import com.ibm.watsonx.ai.timeseries.ForecastRequest;
import com.ibm.watsonx.ai.timeseries.ForecastResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

final class DefaultRestClient
extends DeploymentRestClient {
    private final SyncHttpClient syncHttpClient;
    private final AsyncHttpClient asyncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        Objects.requireNonNull(this.authenticator, "authenticator is mandatory");
        this.syncHttpClient = HttpClientFactory.createSync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
        this.asyncHttpClient = HttpClientFactory.createAsync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public DeploymentResource findById(FindByIdRequest parameters) {
        String deploymentId = parameters.deploymentId();
        StringJoiner queryParameters = new StringJoiner("&", "?", "");
        if (Objects.nonNull(parameters.projectId())) {
            queryParameters.add("project_id=".concat(parameters.projectId()));
        }
        if (Objects.nonNull(parameters.spaceId())) {
            queryParameters.add("space_id=".concat(parameters.spaceId()));
        }
        queryParameters.add("version=".concat(this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(URI.create(this.baseUrl + "/ml/v4/deployments/%s%s".formatted(deploymentId, queryParameters.toString()))).header("Content-Type", "application/json").timeout(Duration.ofMillis(this.timeout.toMillis())).GET();
        if (Objects.nonNull(parameters.transactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.transactionId());
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (DeploymentResource)Json.fromJson((String)((String)httpResponse.body()), DeploymentResource.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TextGenerationResponse generate(String transactionId, String deploymentId, Duration timeout, TextRequest textRequest) {
        URI url = URI.create(this.baseUrl + "/ml/v1/deployments/%s/text/generation?version=%s".formatted(deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (TextGenerationResponse)Json.fromJson((String)((String)httpResponse.body()), TextGenerationResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<Void> generateStreaming(String transactionId, String deploymentId, Duration timeout, TextRequest textRequest, TextGenerationHandler handler) {
        URI url = URI.create(this.baseUrl + "/ml/v1/deployments/%s/text/generation_stream?version=%s".formatted(deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "text/event-stream").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        Flow.Subscriber<String> subscriber = this.textGenerationSubscriber(handler);
        return ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> TextGenerationSubscriber.handleError(t, handler));
    }

    @Override
    public ChatResponse chat(String transactionId, String deploymentId, Duration timeout, TextChatRequest textChatRequest) {
        URI url = URI.create(this.baseUrl + "/ml/v1/deployments/%s/text/chat?version=%s".formatted(deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(timeout);
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ChatResponse)Json.fromJson((String)((String)httpResponse.body()), ChatResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<ChatResponse> chatStreaming(String transactionId, String deploymentId, TextChatRequest textChatRequest, ChatClientContext context, ChatHandler handler) {
        URI url = URI.create(this.baseUrl + "/ml/v1/deployments/%s/text/chat_stream?version=%s".formatted(deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)textChatRequest))).timeout(Duration.ofMillis(textChatRequest.timeLimit()));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        CompletableFuture<ChatResponse> response = new CompletableFuture<ChatResponse>();
        InterceptorContext interceptorContext = new InterceptorContext(context.chatProvider(), context.chatRequest(), null);
        DefaultChatSubscriber chatSubscriber = new DefaultChatSubscriber(new SseEventProcessor(ChatSubscriber.toolHasParameters(textChatRequest.tools()), context.extractionTags()), new ChatHandlerDecorator(handler, interceptorContext, context.toolInterceptor()));
        Flow.Subscriber<String> subscriber = this.subscriber(chatSubscriber, response, !handler.failOnFirstError());
        ((CompletableFuture)this.asyncHttpClient.send(httpRequest.build(), responseInfo -> this.logResponses ? HttpResponse.BodySubscribers.fromLineSubscriber((Flow.Subscriber<? super String>)new SseEventLogger(subscriber, responseInfo.statusCode(), responseInfo.headers())) : HttpResponse.BodySubscribers.fromLineSubscriber(subscriber)).thenAccept(r -> {})).exceptionally(t -> {
            response.completeExceptionally(ChatSubscriber.handleError(t, handler));
            return null;
        });
        return response;
    }

    @Override
    public ForecastResponse forecast(String transactionId, String deploymentId, Duration timeout, ForecastRequest forecastRequest) {
        URI url = URI.create(this.baseUrl + "/ml/v1/deployments/%s/time_series/forecast?version=%s".formatted(deploymentId, this.version));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(url).header("Content-Type", "application/json").header("Accept", "application/json").timeout(timeout).POST(HttpRequest.BodyPublishers.ofString(Json.toJson((Object)forecastRequest)));
        if (Objects.nonNull(transactionId)) {
            httpRequest.header("X-Global-Transaction-Id", transactionId);
        }
        try {
            HttpResponse httpResponse = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (ForecastResponse)Json.fromJson((String)((String)httpResponse.body()), ForecastResponse.class);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Flow.Subscriber<String> textGenerationSubscriber(final TextGenerationHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean success = true;
            private volatile TextGenerationSubscriber chatSubscriber = TextGenerationSubscriber.createSubscriber(handler);

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(String partialMessage) {
                try {
                    this.chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.chatSubscriber.onComplete();
            }
        };
    }

    private Flow.Subscriber<String> subscriber(final ChatSubscriber chatSubscriber, final CompletableFuture<ChatResponse> response, final boolean failOnFirstError) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile boolean continueProcessing = true;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(String partialMessage) {
                try {
                    chatSubscriber.onNext(partialMessage);
                }
                catch (RuntimeException e) {
                    Throwable t = Objects.nonNull(e.getCause()) ? e.getCause() : e;
                    this.continueProcessing = failOnFirstError;
                    chatSubscriber.onError(t).whenComplete((v, err) -> {
                        if (!this.continueProcessing) {
                            response.completeExceptionally(t);
                        }
                    });
                }
                finally {
                    if (this.continueProcessing) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                chatSubscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                chatSubscriber.onComplete().whenComplete((chatResponse, error) -> {
                    if (Objects.nonNull(error)) {
                        error = Objects.nonNull(error.getCause()) ? error.getCause() : error;
                        chatSubscriber.onError((Throwable)error);
                        response.completeExceptionally((Throwable)error);
                    } else {
                        response.complete(chatResponse);
                    }
                });
            }
        };
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends DeploymentRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

