/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.detection.detector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class BaseDetector {
    private final String name;
    private final Map<String, Object> properties;

    protected BaseDetector(Builder<?> builder) {
        this.name = Objects.requireNonNull(builder.name, "name cannot be null");
        this.properties = Objects.requireNonNullElse(builder.properties, new HashMap());
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    static abstract class Builder<T> {
        private String name;
        private Map<String, Object> properties;

        protected Builder(String name) {
            this.name = name;
            this.properties = new HashMap<String, Object>();
        }

        public T threshold(Double threshold) {
            return this.addProperty("threshold", threshold);
        }

        public T addProperty(String name, Object value) {
            this.properties.put(name, value);
            return (T)this;
        }
    }
}

