/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.foundationmodel;

import com.ibm.watsonx.ai.core.Json;
import com.ibm.watsonx.ai.core.auth.Authenticator;
import com.ibm.watsonx.ai.core.factory.HttpClientFactory;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.core.spi.json.TypeToken;
import com.ibm.watsonx.ai.foundationmodel.FoundationModel;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelParameters;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelResponse;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelRestClient;
import com.ibm.watsonx.ai.foundationmodel.FoundationModelTask;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

final class DefaultRestClient
extends FoundationModelRestClient {
    private final SyncHttpClient syncHttpClient;

    DefaultRestClient(Builder builder) {
        super(builder);
        this.syncHttpClient = HttpClientFactory.createSync((Authenticator)this.authenticator, (HttpClient)this.httpClient, (LoggerInterceptor.LogMode)LoggerInterceptor.LogMode.of((boolean)this.logRequests, (boolean)this.logResponses));
    }

    @Override
    public FoundationModelResponse<FoundationModel> getModels(Integer start, Integer limit, String transactionId, Boolean techPreview, String filters) {
        try {
            StringJoiner queryParameters = new StringJoiner("&", "", "");
            queryParameters.add("version=" + this.version);
            if (Objects.nonNull(start)) {
                queryParameters.add("start=" + start);
            }
            if (Objects.nonNull(limit)) {
                queryParameters.add("limit=" + limit);
            }
            if (techPreview.booleanValue()) {
                queryParameters.add("tech_preview=" + techPreview);
            }
            if (Objects.nonNull(filters)) {
                queryParameters.add("filters=" + URLEncoder.encode(filters.toString(), StandardCharsets.UTF_8));
            }
            URI uri = URI.create(this.baseUrl + "/ml/v1/foundation_model_specs?%s".formatted(queryParameters));
            HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).header("Accept", "application/json").timeout(this.timeout).GET();
            if (Objects.nonNull(transactionId)) {
                httpRequest.header("X-Global-Transaction-Id", transactionId);
            }
            HttpResponse response = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (FoundationModelResponse)Json.fromJson((String)((String)response.body()), (TypeToken)new TypeToken<FoundationModelResponse<FoundationModel>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FoundationModelResponse<FoundationModelTask> getTasks(FoundationModelParameters parameters) {
        parameters = Objects.requireNonNullElse(parameters, FoundationModelParameters.builder().build());
        StringJoiner queryParameters = new StringJoiner("&", "", "");
        queryParameters.add("version=" + this.version);
        if (Objects.nonNull(parameters.start())) {
            queryParameters.add("start=" + parameters.start());
        }
        if (Objects.nonNull(parameters.limit())) {
            queryParameters.add("limit=" + parameters.limit());
        }
        URI uri = URI.create(this.baseUrl + "/ml/v1/foundation_model_tasks?%s".formatted(queryParameters));
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder(uri).GET();
        if (Objects.nonNull(parameters.transactionId())) {
            httpRequest.header("X-Global-Transaction-Id", parameters.transactionId());
        }
        try {
            HttpResponse response = this.syncHttpClient.send(httpRequest.build(), HttpResponse.BodyHandlers.ofString());
            return (FoundationModelResponse)Json.fromJson((String)((String)response.body()), (TypeToken)new TypeToken<FoundationModelResponse<FoundationModelTask>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends FoundationModelRestClient.Builder {
        private Builder() {
        }

        @Override
        public DefaultRestClient build() {
            return new DefaultRestClient(this);
        }
    }
}

