/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing;

import com.ibm.watsonx.ai.textprocessing.CosDataConnection;
import com.ibm.watsonx.ai.textprocessing.CosDataLocation;
import com.ibm.watsonx.ai.textprocessing.DataReference;
import java.util.Objects;

public record CosReference(String connection, String bucket) {
    public CosReference {
        Objects.requireNonNull(connection, "connection can't be null");
        Objects.requireNonNull(bucket, "bucket can't be null");
    }

    public DataReference toDataReference(String fileName) {
        Objects.requireNonNull(fileName, "fileName can't be null");
        return new DataReference("connection_asset", new CosDataConnection(this.connection), new CosDataLocation(fileName, this.bucket));
    }

    public static CosReference of(String connection, String bucket) {
        return new CosReference(connection, bucket);
    }
}

