/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textprocessing.textclassification;

import com.ibm.watsonx.ai.WatsonxParameters;
import com.ibm.watsonx.ai.textprocessing.CosReference;
import com.ibm.watsonx.ai.textprocessing.Language;
import com.ibm.watsonx.ai.textprocessing.OcrMode;
import com.ibm.watsonx.ai.textprocessing.textclassification.Parameters;
import com.ibm.watsonx.ai.textprocessing.textclassification.TextClassificationSemanticConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class TextClassificationParameters
extends WatsonxParameters {
    private final String ocrMode;
    private final String classificationMode;
    private final Boolean autoRotationCorrection;
    private final List<String> languages;
    private final TextClassificationSemanticConfig semanticConfig;
    private final boolean removeUploadedFile;
    private final CosReference documentReference;
    private final Map<String, Object> custom;
    private final Duration timeout;

    private TextClassificationParameters(Builder builder) {
        super(builder);
        this.ocrMode = builder.ocrMode;
        this.classificationMode = Objects.nonNull((Object)builder.classificationMode) ? builder.classificationMode.value() : null;
        this.autoRotationCorrection = builder.autoRotationCorrection;
        this.languages = builder.languages;
        this.semanticConfig = builder.semanticConfig;
        this.removeUploadedFile = builder.removeUploadedFile;
        this.documentReference = builder.documentReference;
        this.custom = builder.custom;
        this.timeout = builder.timeout;
    }

    public String ocrMode() {
        return this.ocrMode;
    }

    public String classificationMode() {
        return this.classificationMode;
    }

    public Boolean autoRotationCorrection() {
        return this.autoRotationCorrection;
    }

    public List<String> languages() {
        return this.languages;
    }

    public TextClassificationSemanticConfig semanticConfig() {
        return this.semanticConfig;
    }

    public boolean isRemoveUploadedFile() {
        return this.removeUploadedFile;
    }

    public CosReference documentReference() {
        return this.documentReference;
    }

    public Map<String, Object> custom() {
        return this.custom;
    }

    public Duration timeout() {
        return this.timeout;
    }

    Parameters toParameters() {
        Parameters.SemanticConfig semanticConfig = Objects.isNull(this.semanticConfig()) ? null : new Parameters.SemanticConfig(this.semanticConfig.enableTextHints(), this.semanticConfig.enableGenericKvp(), this.semanticConfig.enableSchemaKvp(), this.semanticConfig.groundingMode(), this.semanticConfig.forceSchemaName(), this.semanticConfig.defaultModelName(), this.semanticConfig.taskModelNameOverride(), this.semanticConfig.schemasMergeStrategy(), this.semanticConfig.schemas());
        return new Parameters(this.ocrMode(), this.classificationMode(), this.autoRotationCorrection(), this.languages(), semanticConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxParameters.Builder<Builder> {
        private String ocrMode;
        private ClassificationMode classificationMode;
        private Boolean autoRotationCorrection;
        private List<String> languages;
        private TextClassificationSemanticConfig semanticConfig;
        private boolean removeUploadedFile = false;
        private CosReference documentReference;
        private Map<String, Object> custom;
        private Duration timeout;

        private Builder() {
        }

        public Builder ocrMode(OcrMode ocrMode) {
            this.ocrMode = switch (ocrMode) {
                case OcrMode.AUTO -> null;
                default -> ocrMode.value();
            };
            return this;
        }

        public Builder classificationMode(ClassificationMode classificationMode) {
            this.classificationMode = classificationMode;
            return this;
        }

        public Builder autoRotationCorrection(boolean autoRotationCorrection) {
            this.autoRotationCorrection = autoRotationCorrection;
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder languages(Language ... languages) {
            return this.languages(Stream.of(languages).map(Language::isoCode).toList());
        }

        public Builder semanticConfig(TextClassificationSemanticConfig semanticConfig) {
            this.semanticConfig = semanticConfig;
            return this;
        }

        public Builder removeUploadedFile(boolean removeUploadedFile) {
            this.removeUploadedFile = removeUploadedFile;
            return this;
        }

        public Builder documentReference(CosReference documentReference) {
            this.documentReference = documentReference;
            return this;
        }

        public Builder addCustomProperty(String key, Object value) {
            Objects.requireNonNull(key, "key cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            this.custom = Objects.requireNonNullElse(this.custom, new HashMap());
            this.custom.put(key, value);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TextClassificationParameters build() {
            return new TextClassificationParameters(this);
        }
    }

    public static enum ClassificationMode {
        EXACT("exact"),
        BINARY("binary");

        private String value;

        private ClassificationMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

