/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tokenization;

import com.ibm.watsonx.ai.Crypto;
import com.ibm.watsonx.ai.WatsonxService;
import com.ibm.watsonx.ai.tokenization.TokenizationParameters;
import com.ibm.watsonx.ai.tokenization.TokenizationRequest;
import com.ibm.watsonx.ai.tokenization.TokenizationResponse;
import com.ibm.watsonx.ai.tokenization.TokenizationRestClient;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TokenizationService
extends WatsonxService.ModelService {
    private final TokenizationRestClient client;

    private TokenizationService(Builder builder) {
        super(builder);
        Objects.requireNonNull(builder.authenticator(), "authenticator cannot be null");
        this.client = (TokenizationRestClient)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)((TokenizationRestClient.Builder)TokenizationRestClient.builder().baseUrl(this.baseUrl)).version(this.version)).logRequests(this.logRequests)).logResponses(this.logResponses)).timeout(this.timeout)).authenticator(builder.authenticator())).httpClient(this.httpClient)).verifySsl(this.verifySsl)).build();
    }

    public TokenizationResponse tokenize(String input) {
        return this.tokenize(input, null);
    }

    public CompletableFuture<TokenizationResponse> asyncTokenize(String input) {
        return this.asyncTokenize(input, null);
    }

    public TokenizationResponse tokenize(String input, TokenizationParameters parameters) {
        TokenizationRequest tokenizationRequest = this.buildTokenizationRequest(input, parameters);
        String transactionId = Objects.nonNull(parameters) ? parameters.transactionId() : null;
        return this.client.tokenize(transactionId, tokenizationRequest);
    }

    public CompletableFuture<TokenizationResponse> asyncTokenize(String input, TokenizationParameters parameters) {
        TokenizationRequest tokenizationRequest = this.buildTokenizationRequest(input, parameters);
        String transactionId = Objects.nonNull(parameters) ? parameters.transactionId() : null;
        return this.client.asyncTokenize(transactionId, tokenizationRequest);
    }

    private TokenizationRequest buildTokenizationRequest(String input, TokenizationParameters parameters) {
        Objects.requireNonNull(input, "Input cannot be null");
        WatsonxService.ProjectService.ProjectSpace projectSpace = this.resolveProjectSpace(parameters);
        String projectId = projectSpace.projectId();
        String spaceId = projectSpace.spaceId();
        String modelId = this.modelId;
        Crypto crypto = null;
        TokenizationRequest.Parameters requestParameters = null;
        if (Objects.nonNull(parameters)) {
            modelId = Objects.requireNonNullElse(parameters.modelId(), this.modelId);
            requestParameters = parameters.toTokenizationRequestParameters();
            crypto = Objects.nonNull(parameters.crypto()) ? new Crypto(parameters.crypto()) : null;
        }
        return new TokenizationRequest(modelId, input, projectId, spaceId, requestParameters, crypto);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WatsonxService.ModelService.Builder<Builder> {
        private Builder() {
        }

        public TokenizationService build() {
            return new TokenizationService(this);
        }
    }
}

