/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.tool.builtin;

import com.ibm.watsonx.ai.chat.ExecutableTool;
import com.ibm.watsonx.ai.chat.model.Tool;
import com.ibm.watsonx.ai.chat.model.ToolArguments;
import com.ibm.watsonx.ai.chat.model.schema.JsonSchema;
import com.ibm.watsonx.ai.core.Experimental;
import com.ibm.watsonx.ai.tool.ToolRequest;
import com.ibm.watsonx.ai.tool.ToolService;
import java.util.Map;
import java.util.Objects;

@Experimental
public class WeatherTool
implements ExecutableTool {
    private static final String TOOL_SCHEMA_NAME = "weather";
    private static final Tool TOOL_SCHEMA = Tool.of("weather", "Find the weather for a location.", JsonSchema.object().property("location", JsonSchema.string("Name of the location")).property("country", JsonSchema.string("Name of the country")).required("location").build());
    private final ToolService toolService;

    public WeatherTool(ToolService toolService) {
        this.toolService = Objects.requireNonNull(toolService, "ToolService can't be null");
    }

    @Override
    public String name() {
        return TOOL_SCHEMA_NAME;
    }

    @Override
    public Tool schema() {
        return TOOL_SCHEMA;
    }

    @Override
    public String execute(ToolArguments args) {
        if (Objects.isNull(args) || !args.contains("location")) {
            throw new IllegalArgumentException("location argument is required");
        }
        String location = (String)args.get("location");
        return args.contains("country") ? this.find(location, (String)args.get("country")) : this.find(location);
    }

    public String find(String location) {
        return this.find(location, null);
    }

    public String find(String location, String country) {
        Objects.requireNonNull(location, "Location can't be null");
        Map<String, Object> structuredInput = Objects.nonNull(country) ? Map.of("location", location, "country", country) : Map.of("location", location);
        return this.toolService.run(ToolRequest.structuredInput("Weather", structuredInput));
    }
}

