/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat;

import com.ibm.watsonx.ai.chat.ChatHandler;
import com.ibm.watsonx.ai.chat.ChatRequest;
import com.ibm.watsonx.ai.chat.ChatResponse;
import com.ibm.watsonx.ai.chat.model.CompletedToolCall;
import com.ibm.watsonx.ai.chat.model.ExtractionTags;
import com.ibm.watsonx.ai.chat.model.PartialChatResponse;
import com.ibm.watsonx.ai.chat.model.PartialToolCall;
import com.ibm.watsonx.ai.chat.model.ResultMessage;
import com.ibm.watsonx.ai.chat.model.ToolCall;
import com.ibm.watsonx.ai.chat.util.StreamingStateTracker;
import com.ibm.watsonx.ai.chat.util.StreamingToolFetcher;
import com.ibm.watsonx.ai.core.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;

public interface ChatProvider {
    public ChatResponse chat(ChatRequest var1);

    public CompletableFuture<Void> chatStreaming(ChatRequest var1, ChatHandler var2);

    default public Void handlerError(Throwable t, ChatHandler handler) {
        Optional.ofNullable(t).map(Throwable::getCause).ifPresent(handler::onError);
        return null;
    }

    default public Flow.Subscriber<String> subscriber(String toolChoiceOption, final Map<String, Boolean> toolHasParameters, final ExtractionTags extractionTags, final ChatHandler handler) {
        return new Flow.Subscriber<String>(){
            private Flow.Subscription subscription;
            private volatile String completionId;
            private volatile String finishReason;
            private volatile String role;
            private volatile String refusal;
            private volatile boolean success = true;
            private volatile boolean pendingSSEError = false;
            private final StringBuffer buffer = new StringBuffer();
            private final ChatResponse chatResponse = new ChatResponse();
            private final List<StreamingToolFetcher> tools = Collections.synchronizedList(new ArrayList());
            private final StreamingStateTracker stateTracker = Objects.nonNull(extractionTags) ? new StreamingStateTracker(extractionTags) : null;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onNext(String partialMessage) {
                try {
                    if (Objects.isNull(partialMessage)) return;
                    if (partialMessage.isBlank()) {
                        return;
                    }
                    if (partialMessage.startsWith("event: error")) {
                        this.pendingSSEError = true;
                        return;
                    }
                    if (!partialMessage.startsWith("data:")) {
                        return;
                    }
                    String messageData = partialMessage.split("data: ")[1];
                    if (this.pendingSSEError) {
                        this.pendingSSEError = false;
                        throw new RuntimeException(messageData);
                    }
                    PartialChatResponse chunk = (PartialChatResponse)Json.fromJson((String)messageData, PartialChatResponse.class);
                    ChatResponse chatResponse = this.chatResponse;
                    // MONITORENTER : chatResponse
                    if (chunk.choices().size() == 0) {
                        this.chatResponse.setUsage(chunk.usage());
                        // MONITOREXIT : chatResponse
                        return;
                    }
                    // MONITOREXIT : chatResponse
                    PartialChatResponse.ResultChoice message = chunk.choices().get(0);
                    ChatResponse chatResponse2 = this.chatResponse;
                    // MONITORENTER : chatResponse2
                    if (Objects.isNull(this.chatResponse.getCreated()) && Objects.nonNull(chunk.created())) {
                        this.chatResponse.setCreated(chunk.created());
                    }
                    if (Objects.isNull(this.chatResponse.getCreatedAt()) && Objects.nonNull(chunk.createdAt())) {
                        this.chatResponse.setCreatedAt(chunk.createdAt());
                    }
                    if (Objects.isNull(this.chatResponse.getId()) && Objects.nonNull(chunk.id())) {
                        this.chatResponse.setId(chunk.id());
                        this.completionId = chunk.id();
                    }
                    if (Objects.isNull(this.chatResponse.getModelId()) && Objects.nonNull(chunk.modelId())) {
                        this.chatResponse.setModelId(chunk.modelId());
                    }
                    if (Objects.isNull(this.chatResponse.getObject()) && Objects.nonNull(chunk.object())) {
                        this.chatResponse.setObject(chunk.object());
                    }
                    if (Objects.isNull(this.chatResponse.getModelVersion()) && Objects.nonNull(chunk.modelVersion())) {
                        this.chatResponse.setModelVersion(chunk.modelVersion());
                    }
                    if (Objects.isNull(this.chatResponse.getModel()) && Objects.nonNull(chunk.model())) {
                        this.chatResponse.setModel(chunk.model());
                    }
                    if (Objects.isNull(this.finishReason) && Objects.nonNull(message.finishReason())) {
                        this.finishReason = message.finishReason();
                    }
                    if (Objects.isNull(this.role) && Objects.nonNull(message.delta().role())) {
                        this.role = message.delta().role();
                    }
                    if (Objects.isNull(this.refusal) && Objects.nonNull(message.delta().refusal())) {
                        this.refusal = message.delta().refusal();
                    }
                    // MONITOREXIT : chatResponse2
                    if (message.delta().toolCalls() != null) {
                        StreamingToolFetcher toolFetcher;
                        this.finishReason = "tool_calls";
                        ToolCall deltaTool = message.delta().toolCalls().get(0);
                        Integer index = deltaTool.index();
                        if (index + 1 > this.tools.size()) {
                            toolFetcher = new StreamingToolFetcher(index);
                            this.tools.add(toolFetcher);
                            if (index - 1 >= 0) {
                                ToolCall tool = this.tools.get(index - 1).build();
                                ChatHandler chatHandler = handler;
                                // MONITORENTER : chatHandler
                                handler.onCompleteToolCall(new CompletedToolCall(this.completionId, tool));
                                // MONITOREXIT : chatHandler
                            }
                        } else {
                            toolFetcher = this.tools.get(index);
                        }
                        toolFetcher.setId(deltaTool.id());
                        if (Objects.nonNull(deltaTool.function())) {
                            String arguments;
                            toolFetcher.setName(deltaTool.function().name());
                            toolFetcher.appendArguments(deltaTool.function().arguments());
                            Boolean toolHasParameter = (Boolean)toolHasParameters.get(toolFetcher.getName());
                            String string = arguments = toolHasParameter != false ? deltaTool.function().arguments() : "{}";
                            if (!arguments.isEmpty()) {
                                PartialToolCall partialToolCall = new PartialToolCall(this.completionId, toolFetcher.getIndex(), toolFetcher.getId(), toolFetcher.getName(), arguments);
                                ChatHandler chatHandler = handler;
                                // MONITORENTER : chatHandler
                                handler.onPartialToolCall(partialToolCall);
                                // MONITOREXIT : chatHandler
                            }
                        }
                    }
                    if (!Objects.nonNull(message.delta().content())) return;
                    String token = message.delta().content();
                    if (token.isEmpty()) {
                        return;
                    }
                    this.buffer.append(token);
                    if (Objects.nonNull(this.stateTracker)) {
                        StreamingStateTracker.Result r = this.stateTracker.update(token);
                        Optional<String> content = r.content();
                        ChatHandler chatHandler = handler;
                        // MONITORENTER : chatHandler
                        switch (r.state()) {
                            case RESPONSE: {
                                content.ifPresent(c -> handler.onPartialResponse((String)c, chunk));
                                return;
                            }
                            case THINKING: {
                                content.ifPresent(c -> handler.onPartialThinking((String)c, chunk));
                                return;
                            }
                            case NO_THINKING: {
                                content.ifPresent(c -> handler.onPartialResponse((String)c, chunk));
                                return;
                            }
                        }
                        // MONITOREXIT : chatHandler
                        return;
                    }
                    ChatHandler chatHandler = handler;
                    // MONITORENTER : chatHandler
                    handler.onPartialResponse(token, chunk);
                    // MONITOREXIT : chatHandler
                    return;
                }
                catch (RuntimeException e) {
                    this.onError(e);
                    this.success = !handler.failOnFirstError();
                    return;
                }
                finally {
                    if (this.success) {
                        this.subscription.request(1L);
                    } else {
                        this.subscription.cancel();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable throwable) {
                ChatHandler chatHandler = handler;
                synchronized (chatHandler) {
                    handler.onError(throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete() {
                try {
                    List<ToolCall> toolCalls = null;
                    String content = this.buffer.toString();
                    if (Objects.nonNull(this.finishReason) && this.finishReason.equals("tool_calls")) {
                        content = null;
                        toolCalls = this.tools.stream().map(StreamingToolFetcher::build).toList();
                        ChatHandler chatHandler = handler;
                        synchronized (chatHandler) {
                            handler.onCompleteToolCall(new CompletedToolCall(this.completionId, toolCalls.get(toolCalls.size() - 1)));
                        }
                    }
                    ResultMessage resultMessage = new ResultMessage(this.role, content, this.refusal, toolCalls);
                    Object object = this.chatResponse;
                    synchronized (object) {
                        this.chatResponse.setChoices(List.of(new ChatResponse.ResultChoice(0, resultMessage, this.finishReason)));
                        this.chatResponse.setExtractionTags(extractionTags);
                    }
                    object = handler;
                    synchronized (object) {
                        handler.onCompleteResponse(this.chatResponse);
                    }
                }
                catch (RuntimeException e) {
                    this.onError(e);
                }
            }
        };
    }
}

