/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.Image;
import com.ibm.watsonx.ai.chat.model.UserContent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;

public record ImageContent(String type, Image imageUrl) implements UserContent
{
    public static final String TYPE = "image_url";

    public ImageContent {
        type = TYPE;
        Objects.requireNonNull(imageUrl);
    }

    public static ImageContent from(File file) throws IOException {
        return ImageContent.from(file, null);
    }

    public static ImageContent from(File file, Image.Detail detail) throws IOException {
        return ImageContent.from(file.toPath(), detail);
    }

    public static ImageContent from(Path path) throws IOException {
        return ImageContent.from(path, null);
    }

    public static ImageContent from(Path path, Image.Detail detail) throws IOException {
        Objects.requireNonNull(path);
        byte[] bytes = Files.readAllBytes(path);
        String mimeType = Files.probeContentType(path);
        String base64Data = Base64.getEncoder().encodeToString(bytes);
        return ImageContent.of(Image.of(mimeType, base64Data));
    }

    public static ImageContent of(Image imageUrl) {
        return new ImageContent(TYPE, imageUrl);
    }

    public static ImageContent of(String mimeType, String image) {
        return ImageContent.of(Image.of(mimeType, image, null));
    }

    public static ImageContent of(String mimeType, String image, Image.Detail detail) {
        return ImageContent.of(Image.of(mimeType, image, detail));
    }
}

