/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.chat.model;

import com.ibm.watsonx.ai.chat.model.JsonSchema;
import java.util.Map;
import java.util.Objects;

public record Tool(String type, Function function) {
    private static final String TYPE = "function";

    public Tool {
        type = TYPE;
        Objects.requireNonNull(function, "function cannot be null");
    }

    public static Tool of(String name, String description) {
        return new Tool(TYPE, new Function(name, description, null));
    }

    public static Tool of(String name, String description, Map<String, Object> parameters) {
        return new Tool(TYPE, new Function(name, description, parameters));
    }

    public static Tool of(String name, String description, JsonSchema parameters) {
        return new Tool(TYPE, new Function(name, description, parameters));
    }

    public static Tool of(String name, String description, JsonSchema.ObjectSchema.Builder parameters) {
        Objects.requireNonNull(parameters);
        return Tool.of(name, description, parameters.build());
    }

    public static Tool of(String name, JsonSchema parameters) {
        return Tool.of(name, null, parameters);
    }

    public static Tool of(String name, JsonSchema.ObjectSchema.Builder parameters) {
        Objects.requireNonNull(parameters);
        return Tool.of(name, parameters.build());
    }

    public boolean hasParameters() {
        return !Objects.isNull(this.function.parameters);
    }

    public record Function(String name, String description, Object parameters) {
    }
}

