/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai.textextraction;

import com.ibm.watsonx.ai.textextraction.TextExtractionRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public record TextExtractionResponse(Metadata metadata, Entity entity) {

    public record Metadata(String id, String createdAt, String modifiedAt, String spaceId, String projectId) {
    }

    public record Entity(TextExtractionRequest.DataReference documentReference, TextExtractionRequest.DataReference resultsReference, ExtractionResult results, TextExtractionRequest.Parameters parameters, Map<String, Object> custom) {
    }

    public static enum Status {
        SUBMITTED("submitted"),
        UPLOADING("uploading"),
        RUNNING("running"),
        DOWNLOADING("downloading"),
        DOWNLOADED("downloaded"),
        COMPLETED("completed"),
        FAILED("failed");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public static Status fromValue(String value) {
            return Stream.of(Status.values()).filter(status -> status.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown Type value: " + value));
        }
    }

    public record Error(String code, String message, String moreInfo) {
    }

    public record ExtractionResult(String status, int numberPagesProcessed, String runningAt, String completedAt, Integer totalPages, List<String> location, Error error) {
    }
}

